/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundMathematicalInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.ISIOperator;

public enum ISCOperator implements Operator<SimpleInterval, BigInteger, CompoundMathematicalInterval>
{
    ADD{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundMathematicalInterval.of(ISIOperator.ADD.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    DIVIDE{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundMathematicalInterval.of(ISIOperator.DIVIDE.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    MODULO{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, BigInteger pValue) {
            if (pValue.signum() == 0) {
                return CompoundMathematicalInterval.bottom();
            }
            if (pValue.signum() < 0) {
                return this.apply(pFirstOperand, pValue.negate());
            }
            if (pFirstOperand.isSingleton()) {
                return CompoundMathematicalInterval.singleton(pFirstOperand.getLowerBound().remainder(pValue));
            }
            BigInteger largestPossibleValue = pValue.subtract(BigInteger.ONE);
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            if (pFirstOperand.containsNegative()) {
                CompoundMathematicalInterval negRange = CompoundMathematicalInterval.of(SimpleInterval.of(largestPossibleValue.negate(), BigInteger.ZERO));
                if (pFirstOperand.hasLowerBound()) {
                    SimpleInterval negPart = pFirstOperand.containsZero() ? SimpleInterval.of(pFirstOperand.getLowerBound(), BigInteger.ZERO) : pFirstOperand;
                    negRange = this.apply(negPart.negate(), pValue).negate();
                }
                result = result.unionWith(negRange);
            }
            if (pFirstOperand.containsPositive()) {
                SimpleInterval posPart;
                BigInteger posPartLength;
                CompoundMathematicalInterval posRange = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, largestPossibleValue));
                if (pFirstOperand.hasUpperBound() && (posPartLength = (posPart = pFirstOperand.containsZero() ? SimpleInterval.of(BigInteger.ZERO, pFirstOperand.getUpperBound()) : pFirstOperand).size()).compareTo(pValue) < 0) {
                    BigInteger quotient = posPart.getUpperBound().divide(pValue);
                    BigInteger modBorder = quotient.multiply(pValue);
                    BigInteger nextModBorder = modBorder.add(pValue);
                    if (modBorder.compareTo(posPart.getLowerBound()) <= 0 && nextModBorder.compareTo(posPart.getUpperBound()) >= 0) {
                        BigInteger bound1 = posPart.getLowerBound().remainder(pValue);
                        BigInteger bound2 = posPart.getUpperBound().remainder(pValue);
                        posRange = CompoundMathematicalInterval.of(SimpleInterval.of(bound1.min(bound2), bound1.max(bound2)));
                    } else if (modBorder.compareTo(posPart.getLowerBound()) > 0 && modBorder.compareTo(posPart.getUpperBound()) < 0) {
                        SimpleInterval posPart1 = SimpleInterval.of(posPart.getLowerBound(), modBorder.subtract(BigInteger.ONE));
                        SimpleInterval posPart2 = SimpleInterval.of(modBorder, posPart.getUpperBound());
                        posRange = this.apply(posPart1, pValue).unionWith(this.apply(posPart2, pValue));
                    }
                }
                result = result.unionWith(posRange);
            }
            return result;
        }
    }
    ,
    MULTIPLY{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundMathematicalInterval.of(ISIOperator.MULTIPLY.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    SHIFT_LEFT{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundMathematicalInterval.of(ISIOperator.SHIFT_LEFT.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    SHIFT_RIGHT{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundMathematicalInterval.of(ISIOperator.SHIFT_RIGHT.apply(pFirstOperand, pSecondOperand));
        }
    };


    @Override
    public abstract CompoundMathematicalInterval apply(SimpleInterval var1, BigInteger var2);
}

