/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical;

import com.google.common.truth.Truth;
import java.math.BigInteger;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.ISIOperator;

public class ISIOperatorTest {
    @Test
    public void testModulo() {
        BigInteger scalarFour = BigInteger.valueOf(4L);
        BigInteger scalarFive = BigInteger.valueOf(5L);
        SimpleInterval zeroToFour = SimpleInterval.of(BigInteger.ZERO, scalarFour);
        SimpleInterval zeroToInf = SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity();
        Truth.assertThat((Object)ISIOperator.MODULO.apply(zeroToInf.negate(), scalarFive)).isEqualTo((Object)zeroToFour.negate());
        Truth.assertThat((Object)ISIOperator.MODULO.apply(zeroToInf.negate(), scalarFive.negate())).isEqualTo((Object)zeroToFour.negate());
    }

    @Test
    public void testShiftLeft() {
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval one = SimpleInterval.singleton(BigInteger.ONE);
        SimpleInterval ten = SimpleInterval.singleton(BigInteger.TEN);
        SimpleInterval zeroToTen = SimpleInterval.span(zero, ten);
        SimpleInterval zeroToFive = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(5L));
        SimpleInterval two = SimpleInterval.singleton(BigInteger.valueOf(2L));
        SimpleInterval oneThousandTwentyFour = SimpleInterval.singleton(BigInteger.valueOf(1024L));
        Truth.assertThat((Object)ISIOperator.SHIFT_LEFT.apply(zero, BigInteger.ZERO)).isEqualTo((Object)zero);
        Truth.assertThat((Object)ISIOperator.SHIFT_LEFT.apply(zero, BigInteger.ONE)).isEqualTo((Object)zero);
        Truth.assertThat((Object)ISIOperator.SHIFT_LEFT.apply(zero, BigInteger.TEN)).isEqualTo((Object)zero);
        Truth.assertThat((Object)ISIOperator.SHIFT_LEFT.apply(one, BigInteger.ZERO)).isEqualTo((Object)one);
        Truth.assertThat((Object)ISIOperator.SHIFT_LEFT.apply(one, BigInteger.ONE)).isEqualTo((Object)two);
        Truth.assertThat((Object)ISIOperator.SHIFT_LEFT.apply(one, BigInteger.TEN)).isEqualTo((Object)oneThousandTwentyFour);
        Truth.assertThat((Object)ISIOperator.SHIFT_LEFT.apply(ten, BigInteger.ZERO)).isEqualTo((Object)ten);
        Truth.assertThat((Object)ISIOperator.SHIFT_LEFT.apply(zeroToFive, BigInteger.ONE)).isEqualTo((Object)zeroToTen);
    }

    @Test
    public void testShiftRight() {
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval one = SimpleInterval.singleton(BigInteger.ONE);
        SimpleInterval ten = SimpleInterval.singleton(BigInteger.TEN);
        SimpleInterval oneToTen = SimpleInterval.span(one, ten);
        SimpleInterval zeroToFive = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(5L));
        Truth.assertThat((Object)ISIOperator.SHIFT_RIGHT.apply(zero, BigInteger.ZERO)).isEqualTo((Object)zero);
        Truth.assertThat((Object)ISIOperator.SHIFT_RIGHT.apply(zero, BigInteger.ONE)).isEqualTo((Object)zero);
        Truth.assertThat((Object)ISIOperator.SHIFT_RIGHT.apply(zero, BigInteger.TEN)).isEqualTo((Object)zero);
        Truth.assertThat((Object)ISIOperator.SHIFT_RIGHT.apply(one, BigInteger.ZERO)).isEqualTo((Object)one);
        Truth.assertThat((Object)ISIOperator.SHIFT_RIGHT.apply(one, BigInteger.ONE)).isEqualTo((Object)zero);
        Truth.assertThat((Object)ISIOperator.SHIFT_RIGHT.apply(one, BigInteger.TEN)).isEqualTo((Object)zero);
        Truth.assertThat((Object)ISIOperator.SHIFT_RIGHT.apply(ten, BigInteger.ZERO)).isEqualTo((Object)ten);
        Truth.assertThat((Object)ISIOperator.SHIFT_RIGHT.apply(oneToTen, BigInteger.ONE)).isEqualTo((Object)zeroToFive);
    }
}

