/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.variableselection;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.AcceptAllVariableSelection;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.VariableSelection;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.VariableSelectionVisitor;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class AcceptSpecifiedVariableSelection<ConstantType>
implements VariableSelection<ConstantType> {
    private final CollectVarsVisitor<ConstantType> collectVarsVisitor = new CollectVarsVisitor();
    private final VariableSelectionJoiner variableSelectionJoiner = new VariableSelectionJoiner();
    private final ImmutableSet<MemoryLocation> specifiedVariables;

    public AcceptSpecifiedVariableSelection(Iterable<? extends MemoryLocation> pIterable) {
        this.specifiedVariables = ImmutableSet.copyOf(pIterable);
    }

    @Override
    public boolean contains(MemoryLocation pMemoryLocation) {
        return FluentIterable.from(this.specifiedVariables).anyMatch(specifiedVar -> AcceptSpecifiedVariableSelection.matches(specifiedVar, pMemoryLocation));
    }

    private static boolean matches(MemoryLocation pPattern, MemoryLocation pTarget) {
        int arraySubscriptIndex;
        if (pTarget.equals(pPattern)) {
            return true;
        }
        if (pPattern.getIdentifier().endsWith("[*]") && (arraySubscriptIndex = pTarget.getIdentifier().indexOf(91)) >= 0) {
            String containedArray = pPattern.getIdentifier().substring(0, pPattern.getIdentifier().indexOf(91));
            String array = pTarget.getIdentifier().substring(arraySubscriptIndex);
            return containedArray.equals(array);
        }
        return false;
    }

    @Override
    public VariableSelection<ConstantType> acceptAssumption(BooleanFormula<ConstantType> pAssumption) {
        Set involvedVariables = (Set)pAssumption.accept(this.collectVarsVisitor);
        for (MemoryLocation involvedVariable : involvedVariables) {
            if (!this.contains(involvedVariable)) continue;
            return this.join(involvedVariables);
        }
        return null;
    }

    @Override
    public VariableSelection<ConstantType> acceptAssignment(MemoryLocation pMemoryLocation, NumeralFormula<ConstantType> pAssumption) {
        if (this.contains(pMemoryLocation)) {
            return this.join((Set)pAssumption.accept(this.collectVarsVisitor));
        }
        return null;
    }

    public String toString() {
        return this.specifiedVariables.toString();
    }

    @Override
    public VariableSelection<ConstantType> join(VariableSelection<ConstantType> pOther) {
        return (VariableSelection)pOther.acceptVisitor(this.variableSelectionJoiner);
    }

    @Override
    public <T> T acceptVisitor(VariableSelectionVisitor<ConstantType, T> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    private VariableSelection<ConstantType> join(Set<MemoryLocation> pSpecifiedVariables) {
        if (this.specifiedVariables == pSpecifiedVariables || this.specifiedVariables.containsAll(pSpecifiedVariables)) {
            return this;
        }
        AcceptSpecifiedVariableSelection<ConstantType> result = new AcceptSpecifiedVariableSelection<ConstantType>(Iterables.concat(this.specifiedVariables, pSpecifiedVariables));
        return result;
    }

    private class VariableSelectionJoiner
    implements VariableSelectionVisitor<ConstantType, VariableSelection<ConstantType>> {
        private VariableSelectionJoiner() {
        }

        @Override
        public VariableSelection<ConstantType> visit(AcceptAllVariableSelection<ConstantType> pAcceptAllVariableSelection) {
            return pAcceptAllVariableSelection;
        }

        @Override
        public VariableSelection<ConstantType> visit(AcceptSpecifiedVariableSelection<ConstantType> pAcceptSpecifiedVariableSelection) {
            if (AcceptSpecifiedVariableSelection.this == pAcceptSpecifiedVariableSelection || AcceptSpecifiedVariableSelection.this.specifiedVariables.containsAll(pAcceptSpecifiedVariableSelection.specifiedVariables)) {
                return AcceptSpecifiedVariableSelection.this;
            }
            return pAcceptSpecifiedVariableSelection.join((Set<MemoryLocation>)AcceptSpecifiedVariableSelection.this.specifiedVariables);
        }
    }
}

