/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.livevar;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.BitSet;
import java.util.Objects;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.livevar.LiveVariablesTransferRelation;
import org.sosy_lab.cpachecker.util.LiveVariables;

class LiveVariablesState
implements LatticeAbstractState<LiveVariablesState>,
Graphable {
    private final BitSet liveVars;
    private final LiveVariablesTransferRelation manager;

    private LiveVariablesState(BitSet pLiveVariables, LiveVariablesTransferRelation pManager) {
        this.manager = pManager;
        Preconditions.checkNotNull((Object)pLiveVariables);
        this.liveVars = pLiveVariables;
    }

    static LiveVariablesState empty(int totalNoVars, LiveVariablesTransferRelation pManager) {
        return new LiveVariablesState(new BitSet(totalNoVars), pManager);
    }

    static LiveVariablesState of(BitSet pLiveVars, LiveVariablesTransferRelation pManager) {
        return new LiveVariablesState((BitSet)pLiveVars.clone(), pManager);
    }

    static LiveVariablesState ofUnique(BitSet pLiveVars, LiveVariablesTransferRelation pManager) {
        return new LiveVariablesState(pLiveVars, pManager);
    }

    LiveVariablesState(int totalNoVars, LiveVariablesTransferRelation pManager) {
        this.liveVars = new BitSet(totalNoVars);
        this.manager = pManager;
    }

    boolean isSubsetOf(LiveVariablesState pState2) {
        BitSet copy = (BitSet)this.liveVars.clone();
        copy.or(pState2.liveVars);
        return copy.equals(pState2.liveVars);
    }

    boolean contains(int variableIdx) {
        return this.liveVars.get(variableIdx);
    }

    boolean containsAny(BitSet data) {
        BitSet copy = (BitSet)this.liveVars.clone();
        copy.and(data);
        return !copy.isEmpty();
    }

    LiveVariablesState removeLiveVariable(int posToRemove) {
        BitSet copy = (BitSet)this.liveVars.clone();
        copy.clear(posToRemove);
        return LiveVariablesState.ofUnique(copy, this.manager);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.liveVars);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiveVariablesState)) {
            return false;
        }
        LiveVariablesState other = (LiveVariablesState)obj;
        return Objects.equals(this.liveVars, other.liveVars);
    }

    @Override
    public LiveVariablesState join(LiveVariablesState pOther) {
        BitSet copy = (BitSet)this.liveVars.clone();
        copy.or(pOther.liveVars);
        if (copy.equals(pOther.liveVars)) {
            return pOther;
        }
        return LiveVariablesState.ofUnique(copy, this.manager);
    }

    @Override
    public boolean isLessOrEqual(LiveVariablesState pOther) {
        return this.isSubsetOf(pOther);
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Joiner.on((String)", ").appendTo(sb, this.toStringIterable());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return Joiner.on((String)", ").join(this.toStringIterable());
    }

    private Iterable<String> toStringIterable() {
        return FluentIterable.from(this.manager.dataToVars(this.liveVars)).transform(LiveVariables.FROM_EQUIV_WRAPPER_TO_STRING);
    }

    BitSet getDataCopy() {
        return (BitSet)this.liveVars.clone();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }
}

