/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.livevar;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.AArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.livevar.LiveVariablesState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

@Options(prefix="cpa.liveVar")
public class LiveVariablesTransferRelation
extends ForwardingTransferRelation<LiveVariablesState, LiveVariablesState, Precision> {
    private final Map<CFANode, BitSet> liveVariables = new HashMap<CFANode, BitSet>();
    @Option(secure=true, description="With this option the handling of global variables during the analysis can be fine-tuned. For example while doing a function-wise analysis it is important to assume that all global variables are live. In contrast to that, while doing a global analysis, we do not need to assume global variables being live.")
    private boolean assumeGlobalVariablesAreAlwaysLive = true;
    private final ImmutableList<Equivalence.Wrapper<ASimpleDeclaration>> allDeclarations;
    private final Map<Equivalence.Wrapper<? extends ASimpleDeclaration>, Integer> declarationListPos;
    private final int noVars;
    private final BitSet addressedOrGlobalVars;
    private final LogManager logger;
    private final CFA cfa;

    public LiveVariablesTransferRelation(Optional<VariableClassification> pVarClass, Configuration pConfig, Language pLang, CFA pCFA, LogManager pLogger) throws InvalidConfigurationException {
        ASimpleDeclaration decl;
        int i;
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.cfa = pCFA;
        if (!this.cfa.getVarClassification().isPresent() && this.cfa.getLanguage() == Language.C) {
            throw new AssertionError((Object)"Without information of the variable classification the live variables analysis cannot be used.");
        }
        VariableClassification variableClassification = pLang == Language.C ? pVarClass.orElseThrow() : null;
        this.allDeclarations = this.gatherAllDeclarations(pCFA);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i2 = 0; i2 < this.allDeclarations.size(); ++i2) {
            builder.put((Object)((Equivalence.Wrapper)this.allDeclarations.get(i2)), (Object)i2);
        }
        this.declarationListPos = builder.buildOrThrow();
        this.noVars = this.allDeclarations.size();
        BitSet addressedVars = new BitSet(this.noVars);
        if (pLang == Language.C) {
            Set<String> addressedVarsSet = ((VariableClassification)Preconditions.checkNotNull((Object)variableClassification)).getAddressedVariables();
            for (i = 0; i < this.noVars; ++i) {
                decl = (ASimpleDeclaration)Preconditions.checkNotNull((Object)((ASimpleDeclaration)((Equivalence.Wrapper)this.allDeclarations.get(i)).get()));
                if (!addressedVarsSet.contains(decl.getQualifiedName())) continue;
                addressedVars.set(i);
            }
        }
        BitSet globalVars = new BitSet(this.noVars);
        if (this.assumeGlobalVariablesAreAlwaysLive) {
            for (i = 0; i < this.noVars; ++i) {
                decl = (ASimpleDeclaration)((Equivalence.Wrapper)this.allDeclarations.get(i)).get();
                if (!(decl instanceof AVariableDeclaration) || !((AVariableDeclaration)decl).isGlobal()) continue;
                globalVars.set(i);
            }
        }
        for (CFANode node : pCFA.getAllNodes()) {
            this.liveVariables.put(node, new BitSet(this.noVars));
        }
        this.addressedOrGlobalVars = (BitSet)addressedVars.clone();
        this.addressedOrGlobalVars.or(globalVars);
    }

    public LiveVariablesState getInitialState(CFANode pNode) {
        if (pNode instanceof FunctionExitNode) {
            FunctionExitNode eNode = (FunctionExitNode)pNode;
            Optional<? extends AVariableDeclaration> returnVarName = eNode.getEntryNode().getReturnVariable();
            if (!returnVarName.isPresent()) {
                return new LiveVariablesState(this.noVars, this);
            }
            Equivalence.Wrapper wrappedVar = LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)returnVarName.get());
            int wrappedVarPos = this.declarationListPos.get(wrappedVar);
            this.liveVariables.get(pNode).set(wrappedVarPos);
            BitSet out = new BitSet(this.noVars);
            out.set(wrappedVarPos);
            return LiveVariablesState.ofUnique(out, this);
        }
        this.logger.log(Level.FINEST, new Object[]{"No FunctionExitNode given, thus creating initial state without having the return variable."});
        return LiveVariablesState.empty(this.noVars, this);
    }

    public ImmutableList<Equivalence.Wrapper<ASimpleDeclaration>> gatherAllDeclarations(CFA pCFA) {
        HashSet<Equivalence.Wrapper> allDecls = new HashSet<Equivalence.Wrapper>();
        for (CFANode node : pCFA.getAllNodes()) {
            if (node instanceof FunctionEntryNode) {
                FunctionEntryNode entryNode = (FunctionEntryNode)node;
                Optional<? extends AVariableDeclaration> returnVarName = entryNode.getReturnVariable();
                if (returnVarName.isPresent()) {
                    allDecls.add(LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)returnVarName.get()));
                }
                allDecls.add(LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)entryNode.getFunctionDefinition()));
                for (AParameterDeclaration aParameterDeclaration : entryNode.getFunctionParameters()) {
                    allDecls.add(LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)aParameterDeclaration));
                }
            }
            for (CFAEdge e : CFAUtils.enteringEdges(node)) {
                if (!(e instanceof ADeclarationEdge)) continue;
                ADeclaration decl = ((ADeclarationEdge)e).getDeclaration();
                allDecls.add(LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)decl));
                if (!(decl instanceof AFunctionDeclaration)) continue;
                AFunctionDeclaration aFunctionDeclaration = (AFunctionDeclaration)decl;
                for (AParameterDeclaration param : aFunctionDeclaration.getParameters()) {
                    allDecls.add(LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)param));
                }
            }
        }
        return ImmutableList.copyOf(allDecls);
    }

    @Override
    protected Collection<LiveVariablesState> postProcessing(@Nullable LiveVariablesState successor, CFAEdge edge) {
        if (successor == null) {
            return ImmutableSet.of();
        }
        this.liveVariables.get(edge.getPredecessor()).or(successor.getDataCopy());
        return Collections.singleton(successor);
    }

    @Override
    protected LiveVariablesState handleAssumption(AssumeEdge cfaEdge, AExpression expression, boolean truthAssumption) throws CPATransferException {
        BitSet out = ((LiveVariablesState)this.state).getDataCopy();
        this.handleExpression(expression, out);
        return LiveVariablesState.ofUnique(out, this);
    }

    @Override
    protected LiveVariablesState handleDeclarationEdge(ADeclarationEdge cfaEdge, ADeclaration decl) throws CPATransferException {
        if (!(decl instanceof AVariableDeclaration)) {
            return (LiveVariablesState)this.state;
        }
        Equivalence.Wrapper varDecl = LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)decl);
        int varDeclPos = this.declarationListPos.get(varDecl);
        AInitializer init = ((AVariableDeclaration)decl).getInitializer();
        if (init == null) {
            return ((LiveVariablesState)this.state).removeLiveVariable(varDeclPos);
        }
        if (!((LiveVariablesState)this.state).contains(varDeclPos)) {
            return (LiveVariablesState)this.state;
        }
        BitSet out = ((LiveVariablesState)this.state).getDataCopy();
        this.getVariablesUsedForInitialization(init, out);
        out.clear(varDeclPos);
        return LiveVariablesState.ofUnique(out, this);
    }

    @Override
    protected LiveVariablesState handleStatementEdge(AStatementEdge cfaEdge, AStatement statement) throws CPATransferException {
        BitSet out = ((LiveVariablesState)this.state).getDataCopy();
        if (statement instanceof AExpressionAssignmentStatement) {
            this.handleAssignment((AAssignment)((Object)statement), out);
            return LiveVariablesState.ofUnique(out, this);
        }
        if (statement instanceof AExpressionStatement) {
            return (LiveVariablesState)this.state;
        }
        if (statement instanceof AFunctionCallAssignmentStatement) {
            this.handleAssignment((AAssignment)((Object)statement), out);
            return LiveVariablesState.ofUnique(out, this);
        }
        if (statement instanceof AFunctionCallStatement) {
            AFunctionCallStatement funcStmt = (AFunctionCallStatement)statement;
            this.getVariablesUsedAsParameters(funcStmt.getFunctionCallExpression().getParameterExpressions(), out);
            return LiveVariablesState.ofUnique(out, this);
        }
        throw new CPATransferException("Missing case for if-then-else statement.");
    }

    @Override
    protected LiveVariablesState handleReturnStatementEdge(AReturnStatementEdge cfaEdge) throws CPATransferException {
        if (!cfaEdge.asAssignment().isPresent()) {
            return (LiveVariablesState)this.state;
        }
        BitSet data = ((LiveVariablesState)this.state).getDataCopy();
        this.handleAssignment(cfaEdge.asAssignment().get(), data);
        return LiveVariablesState.ofUnique(data, this);
    }

    @Override
    protected LiveVariablesState handleFunctionCallEdge(FunctionCallEdge cfaEdge, List<? extends AExpression> arguments, List<? extends AParameterDeclaration> parameters, String calledFunctionName) throws CPATransferException {
        BitSet data = ((LiveVariablesState)this.state).getDataCopy();
        for (AExpression aExpression : arguments) {
            this.handleExpression(aExpression, data);
        }
        for (AParameterDeclaration aParameterDeclaration : parameters) {
            data.clear(this.declarationListPos.get(LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)aParameterDeclaration)));
        }
        return LiveVariablesState.ofUnique(data, this);
    }

    @Override
    protected LiveVariablesState handleFunctionReturnEdge(FunctionReturnEdge cfaEdge, FunctionSummaryEdge fnkCall, AFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        if (summaryExpr instanceof AFunctionCallAssignmentStatement) {
            boolean isLeftHandsideLive = this.isLeftHandSideLive(((AFunctionCallAssignmentStatement)summaryExpr).getLeftHandSide());
            ASimpleDeclaration retVal = cfaEdge.getFunctionEntry().getReturnVariable().get();
            BitSet data = ((LiveVariablesState)this.state).getDataCopy();
            this.handleAssignment((AAssignment)((Object)summaryExpr), data);
            if (isLeftHandsideLive) {
                data.set(this.declarationListPos.get(LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)retVal)));
            }
            return LiveVariablesState.ofUnique(data, this);
        }
        return (LiveVariablesState)this.state;
    }

    @Override
    protected LiveVariablesState handleFunctionSummaryEdge(FunctionSummaryEdge cfaEdge) throws CPATransferException {
        AFunctionCall functionCall = cfaEdge.getExpression();
        BitSet data = ((LiveVariablesState)this.state).getDataCopy();
        if (functionCall instanceof AFunctionCallAssignmentStatement) {
            this.handleAssignment((AAssignment)((Object)functionCall), data);
        } else if (functionCall instanceof AFunctionCallStatement) {
            AFunctionCallStatement funcStmt = (AFunctionCallStatement)functionCall;
            this.getVariablesUsedAsParameters(funcStmt.getFunctionCallExpression().getParameterExpressions(), data);
        } else {
            throw new CPATransferException("Missing case for if-then-else statement.");
        }
        return LiveVariablesState.ofUnique(data, this);
    }

    public Multimap<CFANode, Equivalence.Wrapper<ASimpleDeclaration>> getLiveVariables() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (CFANode node : this.cfa.getAllNodes()) {
            builder.putAll((Object)node, this.dataToVars(this.liveVariables.get(node)));
        }
        return builder.build();
    }

    Collection<Equivalence.Wrapper<ASimpleDeclaration>> dataToVars(BitSet data) {
        ArrayList<Equivalence.Wrapper<ASimpleDeclaration>> out = new ArrayList<Equivalence.Wrapper<ASimpleDeclaration>>();
        int i = data.nextSetBit(0);
        while (i >= 0) {
            out.add((Equivalence.Wrapper<ASimpleDeclaration>)((Equivalence.Wrapper)this.allDeclarations.get(i)));
            assert (i != Integer.MAX_VALUE);
            i = data.nextSetBit(i + 1);
        }
        return out;
    }

    private void handleAssignment(AAssignment assignment, BitSet writeInto) {
        boolean lhsIsPointerDereference;
        ALeftHandSide lhs = assignment.getLeftHandSide();
        boolean isLhsAlwaysLive = this.isAlwaysLive(lhs);
        boolean isLhsLive = this.isLeftHandSideLive(lhs) || assignment instanceof AFunctionCallAssignmentStatement;
        boolean bl = lhsIsPointerDereference = lhs instanceof CFieldReference && (((CFieldReference)lhs).isPointerDereference() || ((CFieldReference)lhs).getFieldOwner() instanceof CPointerExpression) || lhs instanceof AArraySubscriptExpression || lhs instanceof CPointerExpression;
        if (!(isLhsAlwaysLive || isLhsLive || lhsIsPointerDereference)) {
            return;
        }
        BitSet assignedVariable = new BitSet(this.noVars);
        BitSet newLiveVars = new BitSet(this.noVars);
        this.handleLeftHandSide(lhs, assignedVariable);
        this.handleExpression(lhs, newLiveVars);
        newLiveVars.andNot(assignedVariable);
        if (assignment instanceof AExpressionAssignmentStatement) {
            this.handleExpression((AExpression)assignment.getRightHandSide(), newLiveVars);
        } else if (assignment instanceof AFunctionCallAssignmentStatement) {
            AFunctionCallAssignmentStatement funcStmt = (AFunctionCallAssignmentStatement)assignment;
            this.getVariablesUsedAsParameters(funcStmt.getFunctionCallExpression().getParameterExpressions(), newLiveVars);
        } else {
            throw new AssertionError((Object)"Unhandled assignment type.");
        }
        if (isLhsAlwaysLive) {
            writeInto.or(assignedVariable);
            writeInto.or(newLiveVars);
        } else if (isLhsLive) {
            if (assignedVariable.cardinality() > 1) {
                newLiveVars.or(assignedVariable);
                writeInto.or(newLiveVars);
            } else if (lhs instanceof CFieldReference || lhs instanceof AArraySubscriptExpression || lhs instanceof CPointerExpression) {
                writeInto.or(newLiveVars);
            } else {
                writeInto.andNot(assignedVariable);
                writeInto.or(newLiveVars);
            }
        } else {
            assert (lhsIsPointerDereference);
            writeInto.or(assignedVariable);
            writeInto.or(newLiveVars);
        }
    }

    private void getVariablesUsedForInitialization(AInitializer init, BitSet writeInto) throws CPATransferException {
        if (init instanceof CDesignatedInitializer) {
            this.getVariablesUsedForInitialization(((CDesignatedInitializer)init).getRightHandSide(), writeInto);
        } else if (init instanceof CInitializerList) {
            for (CInitializer inList : ((CInitializerList)init).getInitializers()) {
                this.getVariablesUsedForInitialization(inList, writeInto);
            }
        } else if (init instanceof AInitializerExpression) {
            this.handleExpression(((AInitializerExpression)init).getExpression(), writeInto);
        } else {
            throw new CPATransferException("Missing case for if-then-else statement.");
        }
    }

    private boolean isLeftHandSideLive(ALeftHandSide expression) {
        BitSet lhs = new BitSet(this.noVars);
        this.handleLeftHandSide(expression, lhs);
        return this.isAlwaysLive(expression) || ((LiveVariablesState)this.state).containsAny(lhs);
    }

    private void handleExpression(AExpression expression, BitSet writeInto) {
        this.markDeclarationsInBitSet(CFAUtils.traverseRecursively(expression), writeInto);
    }

    private void handleLeftHandSide(ALeftHandSide pLeftHandSide, BitSet writeInto) {
        this.markDeclarationsInBitSet(CFAUtils.traverseLeftHandSideRecursively(pLeftHandSide), writeInto);
    }

    private void markDeclarationsInBitSet(FluentIterable<? extends AAstNode> nodes, BitSet writeInto) {
        for (AIdExpression exp : nodes.filter(AIdExpression.class)) {
            int pos = this.declarationListPos.get(LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)exp.getDeclaration()));
            writeInto.set(pos);
        }
    }

    private boolean isAlwaysLive(ALeftHandSide expression) {
        BitSet lhs = new BitSet(this.noVars);
        this.handleLeftHandSide(expression, lhs);
        lhs.and(this.addressedOrGlobalVars);
        return !lhs.isEmpty();
    }

    private void getVariablesUsedAsParameters(List<? extends AExpression> parameters, BitSet writeInto) {
        for (AExpression aExpression : parameters) {
            this.handleExpression(aExpression, writeInto);
        }
    }
}

