/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.local;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.ConstantIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;

public final class LocalState
implements LatticeAbstractState<LocalState> {
    private final LocalState previousState;
    private final Map<AbstractIdentifier, DataType> DataInfo;
    private final ImmutableSet<String> alwaysLocalData;

    private LocalState(Map<AbstractIdentifier, DataType> oldMap, LocalState state, ImmutableSet<String> localData) {
        this.DataInfo = new HashMap<AbstractIdentifier, DataType>(oldMap);
        this.previousState = state;
        this.alwaysLocalData = localData;
    }

    private LocalState(LocalState state, ImmutableSet<String> localData) {
        this(new HashMap<AbstractIdentifier, DataType>(), state, localData);
    }

    public static LocalState createInitialLocalState(Set<String> localData) {
        return new LocalState(null, (ImmutableSet<String>)ImmutableSet.copyOf(localData));
    }

    public static LocalState createInitialLocalState(LocalState state) {
        return new LocalState(null, state.alwaysLocalData);
    }

    public static LocalState createNextLocalState(LocalState state) {
        return new LocalState(state, state.alwaysLocalData);
    }

    public LocalState getClonedPreviousState() {
        return this.previousState.copy();
    }

    public LocalState copy() {
        return new LocalState(this.DataInfo, this.previousState, this.alwaysLocalData);
    }

    private LocalState clone(LocalState pPreviousState) {
        return new LocalState(this.DataInfo, pPreviousState, this.alwaysLocalData);
    }

    public LocalState expand(LocalState rootState) {
        return this.clone(rootState.previousState);
    }

    public boolean checkIsAlwaysLocal(AbstractIdentifier name) {
        if (name instanceof SingleIdentifier) {
            return this.alwaysLocalData.contains((Object)((SingleIdentifier)name).getName());
        }
        return false;
    }

    private void putIntoDataInfo(AbstractIdentifier name, DataType type) {
        if (this.checkIsAlwaysLocal(name)) {
            this.DataInfo.put(name, DataType.LOCAL);
            return;
        }
        if (type == null) {
            this.DataInfo.remove(name);
        } else {
            this.DataInfo.put(name, type);
        }
    }

    private DataType getDataInfo(AbstractIdentifier name) {
        if (this.checkIsAlwaysLocal(name)) {
            return DataType.LOCAL;
        }
        return this.DataInfo.get(name);
    }

    private boolean isLocal(AbstractIdentifier name) {
        return this.getDataInfo(name) == DataType.LOCAL;
    }

    private boolean isGlobal(AbstractIdentifier name) {
        return this.getDataInfo(name) == DataType.GLOBAL;
    }

    private boolean checkSharednessOfComposedIds(AbstractIdentifier name) {
        return this.checkStatusOfComposedIds(name, (Predicate<? super AbstractIdentifier>)((Predicate)this::isGlobal));
    }

    private boolean checkLocalityOfComposedIds(AbstractIdentifier name) {
        return this.checkStatusOfComposedIds(name, (Predicate<? super AbstractIdentifier>)((Predicate)this::isLocal));
    }

    private boolean checkStatusOfComposedIds(AbstractIdentifier name, Predicate<? super AbstractIdentifier> pred) {
        return FluentIterable.from(name.getComposedIdentifiers()).anyMatch(pred);
    }

    public void set(AbstractIdentifier name, DataType type) {
        if (name.isGlobal() || !name.isDereferenced() || name instanceof ConstantIdentifier) {
            return;
        }
        if (this.checkSharednessOfComposedIds(name)) {
            this.putIntoDataInfo(name, DataType.GLOBAL);
            return;
        }
        this.putIntoDataInfo(name, type);
    }

    public DataType getType(AbstractIdentifier pName) {
        DataType directResult = this.getDataInfo(pName);
        if (this.checkSharednessOfComposedIds(pName)) {
            return DataType.GLOBAL;
        }
        if (directResult == null && this.checkLocalityOfComposedIds(pName)) {
            return DataType.LOCAL;
        }
        return directResult;
    }

    @Override
    public LocalState join(LocalState pState2) {
        if (this.equals(pState2)) {
            return pState2;
        }
        LocalState joinedPreviousState = null;
        if (this.previousState != null && pState2.previousState == null) {
            return pState2;
        }
        if (this.previousState == null && pState2.previousState != null) {
            return this;
        }
        if (this.previousState != null && pState2.previousState != null && !this.previousState.equals(pState2.previousState)) {
            joinedPreviousState = this.previousState.join(pState2.previousState);
        } else if (this.previousState != null && pState2.previousState != null && this.previousState.equals(pState2.previousState)) {
            joinedPreviousState = this.previousState;
        }
        LocalState joinState = this.clone(joinedPreviousState);
        Sets.union(this.DataInfo.keySet(), pState2.DataInfo.keySet()).forEach(id -> joinState.putIntoDataInfo((AbstractIdentifier)id, DataType.max(this.DataInfo.get(id), pState2.DataInfo.get(id))));
        return joinState;
    }

    @Override
    public boolean isLessOrEqual(LocalState pState2) {
        if (FluentIterable.from(this.DataInfo.keySet()).filter(Predicates.not(this::isLocal)).anyMatch(i -> !pState2.DataInfo.containsKey(i) || pState2.isLocal((AbstractIdentifier)i))) {
            return false;
        }
        return !FluentIterable.from(pState2.DataInfo.keySet()).filter(pState2::isLocal).anyMatch(i -> !this.DataInfo.containsKey(i));
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.DataInfo);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalState other = (LocalState)obj;
        return Objects.equals(this.DataInfo, other.DataInfo);
    }

    public String toLog() {
        return FluentIterable.from(this.DataInfo.keySet()).filter(SingleIdentifier.class).transform(id -> id.toLog() + ";" + this.getDataInfo((AbstractIdentifier)id)).join(Joiner.on((String)"\n"));
    }

    @Override
    public String toString() {
        return FluentIterable.from(this.DataInfo.keySet()).transform(id -> id + " - " + this.getDataInfo((AbstractIdentifier)id)).join(Joiner.on((String)"\n"));
    }

    public static enum DataType {
        LOCAL,
        GLOBAL;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static final DataType max(DataType d1, DataType d2) {
            if (d1 == GLOBAL || d2 == GLOBAL) {
                return GLOBAL;
            }
            if (d1 == null || d2 == null) {
                return null;
            }
            return LOCAL;
        }
    }
}

