/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.local;

import com.google.common.io.MoreFiles;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.local.LocalState;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options(prefix="precision")
public class LocalStatistics
implements Statistics {
    @Option(description="A path to a precision output", name="path", secure=true)
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path outputFileName = Path.of("localsave", new String[0]);
    private final LogManager logger;

    public LocalStatistics(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        this.logger = pLogger;
        pConfig.inject((Object)this);
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        if (pReached.size() <= 2) {
            return;
        }
        try {
            TreeMap<CFANode, LocalState> reachedStatistics = new TreeMap<CFANode, LocalState>();
            MoreFiles.createParentDirectories((Path)this.outputFileName, (FileAttribute[])new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.outputFileName, Charset.defaultCharset(), new OpenOption[0]);){
                this.logger.log(Level.FINE, new Object[]{"Write precision to " + this.outputFileName});
                for (AbstractState abstractState : pReached) {
                    CFANode node = AbstractStates.extractLocation(abstractState);
                    LocalState lState = AbstractStates.extractStateByType(abstractState, LocalState.class);
                    if (!reachedStatistics.containsKey(node)) {
                        reachedStatistics.put(node, lState);
                        continue;
                    }
                    LocalState previousState = (LocalState)reachedStatistics.get(node);
                    reachedStatistics.put(node, previousState.join(lState));
                }
                for (Map.Entry entry : reachedStatistics.entrySet()) {
                    writer.append(entry.getKey() + "\n");
                    writer.append(((LocalState)entry.getValue()).toLog() + "\n");
                }
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write LOCALCPA precision");
            return;
        }
    }

    @Override
    public String getName() {
        return "LocalCPA";
    }
}

