/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.local;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CThreadOperationStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.local.LocalState;
import org.sosy_lab.cpachecker.exceptions.HandleCodeException;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.ConstantIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.IdentifierCreator;
import org.sosy_lab.cpachecker.util.identifiers.LocalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.ReturnIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.StructureIdentifier;

@Options(prefix="cpa.local")
public class LocalTransferRelation
extends ForwardingTransferRelation<LocalState, LocalState, Precision> {
    @Option(name="allocatefunctions", description="functions, which allocate new free memory", secure=true)
    private Set<String> allocate = ImmutableSet.of();
    @Option(name="allocateFunctionPattern", description="functions, which allocate new free memory", secure=true)
    private Set<String> allocatePattern = ImmutableSet.of();
    @Option(name="conservativefunctions", description="functions, which do not change sharedness of parameters", secure=true)
    private Set<String> conservationOfSharedness = ImmutableSet.of();
    private final Map<String, Integer> allocateInfo;

    public LocalTransferRelation(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.allocateInfo = FluentIterable.from(this.allocate).toMap(f -> this.getNumOrDefault(config, (String)f));
    }

    private int getNumOrDefault(Configuration config, String funcName) {
        String num = config.getProperty(funcName + ".parameter");
        if (num == null) {
            return 0;
        }
        return Integer.parseInt(num);
    }

    @Override
    protected LocalState handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption) {
        return ((LocalState)this.state).copy();
    }

    @Override
    protected LocalState handleReturnStatementEdge(CReturnStatementEdge cfaEdge) throws HandleCodeException {
        Optional<CExpression> returnExpression = cfaEdge.getExpression();
        LocalState newState = ((LocalState)this.state).copy();
        if (returnExpression.isPresent()) {
            int potentialDereference = LocalTransferRelation.findDereference(returnExpression.orElseThrow().getExpressionType());
            ReturnIdentifier id = ReturnIdentifier.getInstance(0);
            this.assign(newState, (AbstractIdentifier)id, potentialDereference, returnExpression.orElseThrow());
        }
        return newState;
    }

    @Override
    protected LocalState handleFunctionReturnEdge(CFunctionReturnEdge cfaEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String callerFunctionName) throws HandleCodeException {
        CFunctionCall exprOnSummary = cfaEdge.getSummaryEdge().getExpression();
        LocalState newElement = ((LocalState)this.state).getClonedPreviousState();
        if (exprOnSummary instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement assignExp = (CFunctionCallAssignmentStatement)exprOnSummary;
            int dereference = LocalTransferRelation.findDereference(assignExp.getLeftHandSide().getExpressionType());
            AbstractIdentifier leftId = this.createId(assignExp.getLeftHandSide(), 0, new IdentifierCreator(callerFunctionName));
            this.assign(newElement, leftId, dereference, assignExp.getRightHandSide());
        }
        CFunctionSummaryEdge sEdge = cfaEdge.getSummaryEdge();
        CFunctionEntryNode entry = sEdge.getFunctionEntry();
        String funcName = entry.getFunctionName();
        assert (funcName.equals(this.getFunctionName()));
        int allocParameter = this.isParameterAllocatedFunction(funcName) ? this.allocateInfo.get(funcName) : 0;
        List<String> paramNames = entry.getFunctionParameterNames();
        List<CExpression> arguments = sEdge.getExpression().getFunctionCallExpression().getParameterExpressions();
        List<CParameterDeclaration> parameterTypes = entry.getFunctionDefinition().getParameters();
        List<Triple<AbstractIdentifier, LocalVariableIdentifier, Integer>> toProcess = this.extractIdentifiers(arguments, paramNames, parameterTypes, callerFunctionName, funcName);
        for (int i = 0; i < toProcess.size(); ++i) {
            Triple<AbstractIdentifier, LocalVariableIdentifier, Integer> pairId = toProcess.get(i);
            if (allocParameter > 0 && allocParameter == i + 1) {
                this.completeSet(newElement, pairId.getFirst(), pairId.getThird(), LocalState.DataType.LOCAL);
                continue;
            }
            this.completeAssign(newElement, pairId.getFirst(), pairId.getThird(), pairId.getSecond());
        }
        return newElement;
    }

    @Override
    protected LocalState handleFunctionCallEdge(CFunctionCallEdge cfaEdge, List<CExpression> arguments, List<CParameterDeclaration> parameterTypes, String calledFunctionName) {
        LocalState newState = LocalState.createNextLocalState((LocalState)this.state);
        CFunctionEntryNode functionEntryNode = cfaEdge.getSuccessor();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        List<Triple<AbstractIdentifier, LocalVariableIdentifier, Integer>> toProcess = this.extractIdentifiers(arguments, paramNames, parameterTypes, this.getFunctionName(), calledFunctionName);
        boolean isThreadCreate = cfaEdge.getSummaryEdge().getExpression() instanceof CThreadOperationStatement.CThreadCreateStatement;
        for (Triple<AbstractIdentifier, LocalVariableIdentifier, Integer> pairId : toProcess) {
            if (isThreadCreate) {
                this.completeSet(newState, pairId.getSecond(), pairId.getThird(), LocalState.DataType.GLOBAL);
                continue;
            }
            this.completeAssign(newState, pairId.getSecond(), pairId.getThird(), pairId.getFirst());
        }
        return newState;
    }

    @Override
    protected LocalState handleStatementEdge(CStatementEdge cfaEdge, CStatement statement) {
        LocalState newState = ((LocalState)this.state).copy();
        if (statement instanceof CAssignment) {
            CAssignment assignment = (CAssignment)statement;
            this.assign(newState, assignment.getLeftHandSide(), assignment.getRightHandSide());
        }
        return newState;
    }

    @Override
    protected LocalState handleDeclarationEdge(CDeclarationEdge declEdge, CDeclaration decl) {
        LocalState newState = ((LocalState)this.state).copy();
        if (decl instanceof CVariableDeclaration) {
            CInitializer init = ((CVariableDeclaration)decl).getInitializer();
            int deref = LocalTransferRelation.findDereference(decl.getType());
            AbstractIdentifier id = IdentifierCreator.createIdentifier(decl, this.getFunctionName(), 0);
            CType type = decl.getType();
            if (type instanceof CComplexType) {
                if (type instanceof CElaboratedType) {
                    type = ((CElaboratedType)type).getRealType();
                }
                if (type instanceof CCompositeType) {
                    List<CCompositeType.CCompositeTypeMemberDeclaration> members = ((CCompositeType)type).getMembers();
                    for (CCompositeType.CCompositeTypeMemberDeclaration m : members) {
                        int typeDereference = LocalTransferRelation.findDereference(m.getType());
                        if (typeDereference <= 0) continue;
                        StructureIdentifier sId = new StructureIdentifier(m.getName(), m.getType(), 0, id);
                        this.completeSet(newState, sId, typeDereference, LocalState.DataType.LOCAL);
                    }
                }
            }
            if (init instanceof CInitializerExpression) {
                this.assign(newState, id, deref, ((CInitializerExpression)init).getExpression());
            } else if (!decl.isGlobal() && type instanceof CArrayType) {
                this.completeSet(newState, id, deref, LocalState.DataType.LOCAL);
            }
        }
        return newState;
    }

    private boolean handleSpecialFunction(LocalState pSuccessor, AbstractIdentifier leftId, int dereference, CFunctionCallExpression right) {
        String funcName = right.getFunctionNameExpression().toASTString();
        boolean isConservativeFunction = this.conservationOfSharedness.contains(funcName);
        if (this.isAllocatedFunction(funcName) && this.allocateInfo.get(funcName) == 0) {
            pSuccessor.set(leftId, LocalState.DataType.LOCAL);
            return true;
        }
        if (isConservativeFunction) {
            List<CExpression> parameters = right.getParameterExpressions();
            CExpression targetParam = parameters.get(0);
            AbstractIdentifier paramId = this.createId(targetParam, dereference);
            this.alias(pSuccessor, leftId, paramId);
            return true;
        }
        return false;
    }

    private List<Triple<AbstractIdentifier, LocalVariableIdentifier, Integer>> extractIdentifiers(List<CExpression> arguments, List<String> paramNames, List<CParameterDeclaration> parameterTypes, String callerFunction, String calledFunction) {
        ArrayList<Triple<AbstractIdentifier, LocalVariableIdentifier, Integer>> result = new ArrayList<Triple<AbstractIdentifier, LocalVariableIdentifier, Integer>>();
        for (int i = 0; i < arguments.size() && i < paramNames.size(); ++i) {
            CExpression currentArgument = arguments.get(i);
            int dereference = LocalTransferRelation.findDereference(parameterTypes.get(i).getType());
            LocalVariableIdentifier innerId = new LocalVariableIdentifier(paramNames.get(i), parameterTypes.get(i).getType(), calledFunction, 0);
            AbstractIdentifier outerId = this.createId(currentArgument, 0, new IdentifierCreator(callerFunction));
            result.add(Triple.of(outerId, innerId, dereference));
        }
        return result;
    }

    private AbstractIdentifier createId(CExpression expression, int dereference, IdentifierCreator idCreator) {
        return idCreator.createIdentifier(expression, dereference);
    }

    private AbstractIdentifier createId(CExpression expression, int dereference) {
        return this.createId(expression, dereference, new IdentifierCreator(this.getFunctionName()));
    }

    private void assign(LocalState pSuccessor, CExpression left, CRightHandSide right) {
        AbstractIdentifier leftId = this.createId(left, 0);
        if (!(leftId instanceof ConstantIdentifier)) {
            int leftDereference = LocalTransferRelation.findDereference(left.getExpressionType());
            if (right instanceof CExpression) {
                this.assign(pSuccessor, leftId, leftDereference, (CExpression)right);
            } else if (right instanceof CFunctionCallExpression) {
                this.assign(pSuccessor, leftId, leftDereference, (CFunctionCallExpression)right);
            }
        }
    }

    private void assign(LocalState pSuccessor, AbstractIdentifier leftId, int leftDereference, CFunctionCallExpression right) {
        for (int i = 0; i <= leftDereference; ++i) {
            if (!this.handleSpecialFunction(pSuccessor, leftId, i, right)) {
                ReturnIdentifier returnId = ReturnIdentifier.getInstance(i);
                this.alias(pSuccessor, leftId, returnId);
            }
            leftId = this.incrementDereference(leftId);
        }
    }

    private void assign(LocalState pSuccessor, AbstractIdentifier leftId, int leftDereference, CExpression right) {
        AbstractIdentifier rightId = this.createId(right, 0);
        this.completeAssign(pSuccessor, leftId, leftDereference, rightId);
    }

    private void completeAssign(LocalState pSuccessor, AbstractIdentifier leftId, int dereference, AbstractIdentifier rightId) {
        if (dereference > 0) {
            leftId = this.incrementDereference(leftId);
            rightId = this.incrementDereference(rightId);
            for (int i = 1; i <= dereference; ++i) {
                this.alias(pSuccessor, leftId, rightId);
                leftId = this.incrementDereference(leftId);
                rightId = this.incrementDereference(rightId);
            }
        }
    }

    private void completeSet(LocalState pSuccessor, AbstractIdentifier id, int dereference, LocalState.DataType type) {
        for (int i = 0; i <= dereference; ++i) {
            pSuccessor.set(id, type);
            id = this.incrementDereference(id);
        }
    }

    private void alias(LocalState pSuccessor, AbstractIdentifier leftId, AbstractIdentifier rightId) {
        if (leftId.isGlobal() && !pSuccessor.checkIsAlwaysLocal(leftId)) {
            pSuccessor.set(rightId, LocalState.DataType.GLOBAL);
        } else {
            LocalState.DataType type = this.getMemoryType(rightId);
            pSuccessor.set(leftId, type);
        }
    }

    private LocalState.DataType getMemoryType(AbstractIdentifier id) {
        LocalState.DataType type = ((LocalState)this.state).getType(id);
        if (type == null) {
            if (id instanceof ConstantIdentifier) {
                return LocalState.DataType.LOCAL;
            }
            if (!id.isDereferenced()) {
                if (id.isGlobal()) {
                    return LocalState.DataType.GLOBAL;
                }
                return LocalState.DataType.LOCAL;
            }
        }
        return type;
    }

    private AbstractIdentifier incrementDereference(AbstractIdentifier id) {
        return id.cloneWithDereference(id.getDereference() + 1);
    }

    public static int findDereference(CType type) {
        if (type instanceof CPointerType) {
            CPointerType pointerType = (CPointerType)type;
            return LocalTransferRelation.findDereference(pointerType.getType()) + 1;
        }
        if (type instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)type;
            return LocalTransferRelation.findDereference(arrayType.getType()) + 1;
        }
        if (type instanceof CTypedefType) {
            return LocalTransferRelation.findDereference(((CTypedefType)type).getRealType());
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAllocatedFunction(String funcName) {
        if (this.allocate.contains(funcName)) return true;
        if (!FluentIterable.from(this.allocatePattern).anyMatch(funcName::contains)) return false;
        return true;
    }

    private boolean isParameterAllocatedFunction(String funcName) {
        return this.allocateInfo.containsKey(funcName) && this.allocateInfo.get(funcName) > 0;
    }
}

