/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.location.LocationCPAFactory;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.location.LocationStateFactory;
import org.sosy_lab.cpachecker.cpa.location.LocationTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class LocationCPA
extends AbstractCPA
implements ConfigurableProgramAnalysisWithBAM,
ProofChecker.ProofCheckerCPA {
    private final LocationStateFactory stateFactory;

    private LocationCPA(LocationStateFactory pStateFactory) {
        super("sep", "sep", new LocationTransferRelation(pStateFactory));
        this.stateFactory = pStateFactory;
        Optional<CFAInfo> cfaInfo = GlobalInfo.getInstance().getCFAInfo();
        if (cfaInfo.isPresent()) {
            cfaInfo.orElseThrow().storeLocationStateFactory(this.stateFactory);
        }
    }

    public static CPAFactory factory() {
        return new LocationCPAFactory(AnalysisDirection.FORWARD);
    }

    public static LocationCPA create(CFA pCFA, Configuration pConfig) throws InvalidConfigurationException {
        return new LocationCPA(new LocationStateFactory(pCFA, AnalysisDirection.FORWARD, pConfig));
    }

    @Override
    public LocationState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return this.stateFactory.getState(pNode);
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        ImmutableSet successors = ImmutableSet.copyOf(pSuccessors);
        ImmutableSet actualSuccessors = ImmutableSet.copyOf(this.getTransferRelation().getAbstractSuccessorsForEdge(pElement, SingletonPrecision.getInstance(), pCfaEdge));
        return successors.equals((Object)actualSuccessors);
    }
}

