/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPABackwards;

class LocationCPAFactory
extends AbstractCPAFactory {
    private final AnalysisDirection locationType;
    private CFA cfa;

    public LocationCPAFactory(AnalysisDirection pLocationType) {
        this.locationType = pLocationType;
    }

    @Override
    @CanIgnoreReturnValue
    public <T> LocationCPAFactory set(T pObject, Class<T> pClass) {
        if (CFA.class.isAssignableFrom(pClass)) {
            this.cfa = (CFA)pObject;
        } else {
            super.set(pObject, pClass);
        }
        return this;
    }

    @Override
    public ConfigurableProgramAnalysis createInstance() throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)this.cfa, (Object)"CFA instance needed to create LocationCPA");
        switch (this.locationType) {
            case BACKWARD: {
                return LocationCPABackwards.create(this.cfa, this.getConfiguration());
            }
            case FORWARD: {
                return LocationCPA.create(this.cfa, this.getConfiguration());
            }
        }
        throw new AssertionError();
    }
}

