/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class LocationState
implements AbstractStateWithLocation,
AbstractQueryableState,
Partitionable,
Serializable {
    private static final long serialVersionUID = -801176497691618779L;
    private transient CFANode locationNode;
    private boolean followFunctionCalls;

    private static boolean isNoFunctionCall(CFAEdge e) {
        return !(e instanceof FunctionCallEdge) && !(e instanceof FunctionReturnEdge);
    }

    LocationState(CFANode pLocationNode, boolean pFollowFunctionCalls) {
        this.locationNode = pLocationNode;
        this.followFunctionCalls = pFollowFunctionCalls;
    }

    @Override
    public CFANode getLocationNode() {
        return this.locationNode;
    }

    @Override
    public Iterable<CFAEdge> getOutgoingEdges() {
        if (this.followFunctionCalls) {
            return CFAUtils.leavingEdges(this.locationNode);
        }
        return CFAUtils.allLeavingEdges(this.locationNode).filter(LocationState::isNoFunctionCall);
    }

    @Override
    public Iterable<CFAEdge> getIngoingEdges() {
        if (this.followFunctionCalls) {
            return CFAUtils.enteringEdges(this.locationNode);
        }
        return CFAUtils.allEnteringEdges(this.locationNode).filter(LocationState::isNoFunctionCall);
    }

    @Override
    public String toString() {
        String loc = this.locationNode.describeFileLocation();
        return this.locationNode + (String)(loc.isEmpty() ? "" : " (" + loc + ")");
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        List parts = Splitter.on((String)"==").trimResults().splitToList((CharSequence)pProperty);
        if (parts.size() != 2) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not split the property string correctly.");
        }
        switch (((String)parts.get(0)).toLowerCase()) {
            case "line": {
                try {
                    int queryLine = Integer.parseInt((String)parts.get(1));
                    for (CFAEdge edge : CFAUtils.enteringEdges(this.locationNode)) {
                        if (edge.getLineNumber() != queryLine) continue;
                        return true;
                    }
                    return false;
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the integer \"" + (String)parts.get(1) + "\"");
                }
            }
            case "functionname": {
                return this.locationNode.getFunctionName().equals(parts.get(1));
            }
            case "label": {
                return this.locationNode instanceof CFALabelNode ? ((CFALabelNode)this.locationNode).getLabel().equals(parts.get(1)) : false;
            }
            case "nodenumber": {
                try {
                    int queryNumber = Integer.parseInt((String)parts.get(1));
                    return this.locationNode.getNodeNumber() == queryNumber;
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the integer \"" + (String)parts.get(1) + "\"");
                }
            }
            case "mainentry": {
                CFAEdge enteringEdge;
                return this.locationNode.getNumEnteringEdges() == 1 && this.locationNode.getFunctionName().equals(parts.get(1)) && (enteringEdge = this.locationNode.getEnteringEdge(0)).getDescription().equals("Function start dummy edge") && enteringEdge.getEdgeType() == CFAEdgeType.BlankEdge && FileLocation.DUMMY.equals(enteringEdge.getFileLocation());
            }
        }
        throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. \"" + (String)parts.get(0) + "\" is no valid keyword");
    }

    @Override
    public String getCPAName() {
        return "location";
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        if (pProperty.equalsIgnoreCase("lineno")) {
            if (this.locationNode.getNumEnteringEdges() > 0) {
                return this.locationNode.getEnteringEdge(0).getLineNumber();
            }
            return 0;
        }
        return this.checkProperty(pProperty);
    }

    @Override
    public Object getPartitionKey() {
        return this;
    }

    private Object writeReplace() {
        return new SerialProxy(this.locationNode.getNodeNumber());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerialProxy
    implements Serializable {
        private static final long serialVersionUID = 6889568471468710163L;
        private final int nodeNumber;

        public SerialProxy(int nodeNumber) {
            this.nodeNumber = nodeNumber;
        }

        private Object readResolve() {
            CFAInfo cfaInfo = GlobalInfo.getInstance().getCFAInfo().orElseThrow();
            return cfaInfo.getLocationStateFactory().getState(cfaInfo.getNodeByNodeNumber(this.nodeNumber));
        }
    }

    static class BackwardsLocationState
    extends LocationState {
        private static final long serialVersionUID = 6825257572921009531L;

        BackwardsLocationState(CFANode locationNode, boolean pFollowFunctionCalls) {
            super(locationNode, pFollowFunctionCalls);
        }

        @Override
        public Iterable<CFAEdge> getOutgoingEdges() {
            return super.getIngoingEdges();
        }

        @Override
        public Iterable<CFAEdge> getIngoingEdges() {
            return super.getOutgoingEdges();
        }
    }
}

