/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.cpa.location.LocationState;

@Options(prefix="cpa.location")
public class LocationStateFactory {
    private final LocationState[] states;
    private final AnalysisDirection locationType;
    @Option(secure=true, description="With this option enabled, function calls that occur in the CFA are followed. By disabling this option one can traverse a function without following function calls (in this case FunctionSummaryEdges are used)")
    private boolean followFunctionCalls = true;

    public LocationStateFactory(CFA pCfa, AnalysisDirection pLocationType, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.locationType = (AnalysisDirection)((Object)Preconditions.checkNotNull((Object)((Object)pLocationType)));
        Collection<CFANode> tmpNodes = pCfa.getAllNodes();
        ImmutableSortedSet allNodes = tmpNodes instanceof ImmutableSortedSet ? (ImmutableSortedSet)tmpNodes : ImmutableSortedSet.copyOf(tmpNodes);
        int maxNodeNumber = ((CFANode)allNodes.last()).getNodeNumber();
        this.states = new LocationState[maxNodeNumber + 1];
        for (CFANode node : allNodes) {
            LocationState state;
            this.states[node.getNodeNumber()] = state = this.createLocationState(node);
        }
    }

    public LocationState getState(CFANode node) {
        int nodeNumber = ((CFANode)Preconditions.checkNotNull((Object)node)).getNodeNumber();
        if (nodeNumber >= 0 && nodeNumber < this.states.length) {
            return (LocationState)Preconditions.checkNotNull((Object)this.states[nodeNumber], (String)"LocationState for CFANode %s in function %s requested, but this node is not part of the current CFA.", (Object)node, (Object)node.getFunctionName());
        }
        return this.createLocationState(node);
    }

    private LocationState createLocationState(CFANode node) {
        return this.locationType == AnalysisDirection.BACKWARD ? new LocationState.BackwardsLocationState(node, this.followFunctionCalls) : new LocationState(node, this.followFunctionCalls);
    }
}

