/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.location.LocationStateFactory;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class LocationTransferRelation
implements TransferRelation {
    private final LocationStateFactory factory;

    public LocationTransferRelation(LocationStateFactory pFactory) {
        this.factory = pFactory;
    }

    public Collection<LocationState> getAbstractSuccessorsForEdge(AbstractState element, Precision prec, CFAEdge cfaEdge) {
        CFANode node = ((LocationState)element).getLocationNode();
        if (CFAUtils.allLeavingEdges(node).contains((Object)cfaEdge)) {
            return Collections.singleton(this.factory.getState(cfaEdge.getSuccessor()));
        }
        return ImmutableSet.of();
    }

    public Collection<LocationState> getAbstractSuccessors(AbstractState element, Precision prec) throws CPATransferException {
        CFANode node = ((LocationState)element).getLocationNode();
        return CFAUtils.successorsOf(node).transform(n -> this.factory.getState((CFANode)n)).toList();
    }
}

