/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.location.LocationStateFactory;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class LocationTransferRelationBackwards
implements TransferRelation {
    private final LocationStateFactory factory;

    public LocationTransferRelationBackwards(LocationStateFactory pFactory) {
        this.factory = pFactory;
    }

    public Collection<LocationState> getAbstractSuccessorsForEdge(AbstractState state, Precision prec, CFAEdge cfaEdge) throws CPATransferException {
        LocationState predState = (LocationState)state;
        CFANode predLocation = predState.getLocationNode();
        if (CFAUtils.allEnteringEdges(predLocation).contains((Object)cfaEdge)) {
            return Collections.singleton(this.factory.getState(cfaEdge.getPredecessor()));
        }
        return ImmutableSet.of();
    }

    public Collection<LocationState> getAbstractSuccessors(AbstractState state, Precision prec) throws CPATransferException {
        CFANode predLocation = ((LocationState)state).getLocationNode();
        ArrayList<LocationState> allSuccessors = new ArrayList<LocationState>(predLocation.getNumEnteringEdges());
        for (CFANode predecessor : CFAUtils.predecessorsOf(predLocation)) {
            allSuccessors.add(this.factory.getState(predecessor));
        }
        return allSuccessors;
    }
}

