/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockStateBuilder;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleNode;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleState;

public abstract class AbstractLockState
implements LatticeAbstractState<AbstractLockState>,
CompatibleState {
    protected final AbstractLockState toRestore;

    protected AbstractLockState() {
        this.toRestore = null;
    }

    protected AbstractLockState(AbstractLockState state) {
        this.toRestore = state;
    }

    public int getSize() {
        return this.getLocks().size();
    }

    public abstract Object getHashCodeForState();

    public int getCounter(String lockName, String varName) {
        LockIdentifier lock = LockIdentifier.of(lockName, varName, LockIdentifier.LockType.GLOBAL_LOCK);
        return this.getCounter(lock);
    }

    public abstract int getCounter(LockIdentifier var1);

    protected abstract Set<LockIdentifier> getLocks();

    @Override
    public boolean isCompatibleWith(CompatibleState state) {
        Preconditions.checkArgument((boolean)(state instanceof AbstractLockState));
        AbstractLockState pLocks = (AbstractLockState)state;
        return Sets.intersection(this.getLocks(), pLocks.getLocks()).isEmpty();
    }

    public Collection<LockIdentifier> getIntersection(CompatibleState state) {
        Preconditions.checkArgument((boolean)(state instanceof AbstractLockState));
        AbstractLockState pLocks = (AbstractLockState)state;
        return ImmutableSet.copyOf((Collection)Sets.intersection(this.getLocks(), pLocks.getLocks()));
    }

    public abstract AbstractLockStateBuilder builder();

    public abstract Multiset<LockEffect> getDifference(AbstractLockState var1);

    @Override
    public boolean isLessOrEqual(AbstractLockState other) {
        return FluentIterable.from(other.getLocks()).allMatch(this.getLocks()::contains);
    }

    @Override
    public abstract CompatibleNode getCompatibleNode();

    @Override
    public AbstractLockState join(AbstractLockState pOther) {
        throw new UnsupportedOperationException("Operation join isn't supported for LockStatisticsCPA");
    }

    protected AbstractLockState getRestoredState() {
        return this.toRestore;
    }
}

