/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cpa.lock.AnnotationInfo;
import org.sosy_lab.cpachecker.cpa.lock.LockIdUnprepared;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.cpa.lock.LockInfo;
import org.sosy_lab.cpachecker.cpa.lock.effects.AcquireLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.ReleaseLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.ResetLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.SetLockEffect;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="cpa.lock")
public class ConfigurationParser {
    private Configuration config;
    @Option(name="lockinfo", description="contains all lock names", secure=true)
    private Set<String> lockinfo = ImmutableSet.of();
    @Option(name="annotate", description=" annotated functions, which are known to works right", secure=true)
    private Set<String> annotated;

    ConfigurationParser(Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
    }

    public LockInfo parseLockInfo() {
        HashMap<String, Integer> tmpInfo = new HashMap<String, Integer>();
        HashMap<String, Pair<LockEffect, LockIdUnprepared>> functionEffects = new HashMap<String, Pair<LockEffect, LockIdUnprepared>>();
        HashMap<String, LockIdentifier> variableEffects = new HashMap<String, LockIdentifier>();
        for (String lockName : this.lockinfo) {
            int num = this.getValue(lockName + ".maxDepth", 10);
            functionEffects.putAll(this.createMap(lockName, "lock", AcquireLockEffect.getInstance()));
            functionEffects.putAll(this.createMap(lockName, "unlock", ReleaseLockEffect.getInstance()));
            functionEffects.putAll(this.createMap(lockName, "reset", ResetLockEffect.getInstance()));
            String tmpString = this.config.getProperty(lockName + ".variable");
            if (tmpString != null) {
                tmpString = CharMatcher.whitespace().removeFrom((CharSequence)tmpString);
                Splitter.on((String)",").splitToList((CharSequence)tmpString).forEach(k -> variableEffects.put((String)k, LockIdentifier.of(lockName)));
            }
            if (!Strings.isNullOrEmpty((String)(tmpString = this.config.getProperty(lockName + ".setlevel")))) {
                functionEffects.put(tmpString, Pair.of(SetLockEffect.getInstance(), new LockIdUnprepared(lockName, 0)));
            }
            tmpInfo.put(lockName, num);
        }
        return new LockInfo(functionEffects, variableEffects, tmpInfo);
    }

    private Map<String, Pair<LockEffect, LockIdUnprepared>> createMap(String lockName, String target, LockEffect effect) {
        String tmpString = this.config.getProperty(lockName + "." + target);
        if (tmpString != null) {
            tmpString = CharMatcher.whitespace().removeFrom((CharSequence)tmpString);
            return FluentIterable.from((Iterable)Splitter.on((String)",").splitToList((CharSequence)tmpString)).toMap(f -> Pair.of(effect, new LockIdUnprepared(lockName, this.getValue(lockName + "." + f + ".parameters", 0))));
        }
        return ImmutableMap.of();
    }

    private int getValue(String property, int defaultValue) {
        int num;
        try {
            num = Integer.parseInt(this.config.getProperty(property));
        }
        catch (NumberFormatException e) {
            num = defaultValue;
        }
        return num;
    }

    public ImmutableMap<String, AnnotationInfo> parseAnnotatedFunctions() {
        ImmutableMap.Builder annotatedfunctions = ImmutableMap.builder();
        if (this.annotated != null) {
            for (String fName : this.annotated) {
                Set<LockIdentifier> freeLocks = this.createAnnotationMap(fName, "free");
                Set<LockIdentifier> restoreLocks = this.createAnnotationMap(fName, "restore");
                Set<LockIdentifier> resetLocks = this.createAnnotationMap(fName, "reset");
                Set<LockIdentifier> captureLocks = this.createAnnotationMap(fName, "lock");
                annotatedfunctions.put((Object)fName, (Object)new AnnotationInfo(freeLocks, restoreLocks, resetLocks, captureLocks));
            }
        }
        return annotatedfunctions.buildOrThrow();
    }

    private Set<LockIdentifier> createAnnotationMap(String function, String target) {
        TreeSet<LockIdentifier> result = new TreeSet<LockIdentifier>();
        String property = this.config.getProperty("annotate." + function + "." + target);
        if (property != null) {
            property = CharMatcher.whitespace().removeFrom((CharSequence)property);
            List lockNames = Splitter.on((String)",").splitToList((CharSequence)property);
            for (String fullName : lockNames) {
                LockIdentifier parsedId;
                if (fullName.matches(".*\\(.*")) {
                    List stringArray = Splitter.on((String)"(").splitToList((CharSequence)fullName);
                    assert (stringArray.size() == 2);
                    parsedId = LockIdentifier.of((String)stringArray.get(0), (String)stringArray.get(1));
                } else {
                    parsedId = LockIdentifier.of(fullName, "");
                }
                result.add(parsedId);
            }
        }
        return result;
    }
}

