/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockState;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockStateBuilder;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.cpa.lock.LockState;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleNode;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleState;

public final class DeadLockState
extends AbstractLockState {
    private final List<LockIdentifier> lockList;

    public DeadLockState() {
        this.lockList = new LinkedList<LockIdentifier>();
    }

    DeadLockState(List<LockIdentifier> gLocks, DeadLockState state) {
        super(state);
        this.lockList = new LinkedList<LockIdentifier>(gLocks);
    }

    @Override
    public List<LockIdentifier> getHashCodeForState() {
        return this.lockList;
    }

    @Override
    public String toString() {
        if (!this.lockList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            return Joiner.on((String)",").appendTo(sb, this.lockList).toString();
        }
        return "Without locks";
    }

    @Override
    public int getCounter(LockIdentifier lock) {
        return FluentIterable.from(this.lockList).filter(lock::equals).size();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lockList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeadLockState other = (DeadLockState)obj;
        return Objects.equals(this.toRestore, other.toRestore) && Objects.equals(this.lockList, other.lockList);
    }

    @Override
    public int compareTo(CompatibleState pOther) {
        DeadLockState other = (DeadLockState)pOther;
        int result = other.getSize() - this.getSize();
        if (result != 0) {
            return result;
        }
        Iterator<LockIdentifier> iterator1 = this.lockList.iterator();
        Iterator<LockIdentifier> iterator2 = other.lockList.iterator();
        while (iterator1.hasNext()) {
            LockIdentifier lockId2;
            LockIdentifier lockId1 = iterator1.next();
            result = lockId1.compareTo(lockId2 = iterator2.next());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public DeadLockStateBuilder builder() {
        return new DeadLockStateBuilder(this);
    }

    @Override
    public Multiset<LockEffect> getDifference(AbstractLockState other) {
        throw new UnsupportedOperationException("Effects are not supported for dead lock detection");
    }

    @Override
    public CompatibleNode getCompatibleNode() {
        return new DeadLockTreeNode(this.lockList);
    }

    @Override
    protected Set<LockIdentifier> getLocks() {
        return ImmutableSet.copyOf(this.lockList);
    }

    public class DeadLockStateBuilder
    extends AbstractLockStateBuilder {
        private List<LockIdentifier> mutableLockList;

        public DeadLockStateBuilder(DeadLockState state) {
            super(state);
            this.mutableLockList = new LinkedList<LockIdentifier>(state.lockList);
        }

        @Override
        public void add(LockIdentifier lockId) {
            this.mutableLockList.add(lockId);
        }

        @Override
        public void free(LockIdentifier lockId) {
            for (int i = this.mutableLockList.size() - 1; i >= 0; --i) {
                LockIdentifier id = this.mutableLockList.get(i);
                if (!id.equals(lockId)) continue;
                this.mutableLockList.remove(i);
                return;
            }
        }

        @Override
        public void reset(LockIdentifier lockId) {
            while (this.mutableLockList.remove(lockId)) {
            }
        }

        @Override
        public void set(LockIdentifier lockId, int num) {
            throw new UnsupportedOperationException("Set annotations are not supported for dead lock analysis");
        }

        @Override
        public void restore(LockIdentifier lockId) {
            throw new UnsupportedOperationException("Restore annotations are not supported for dead lock analysis");
        }

        @Override
        public void restoreAll() {
            this.mutableLockList = ((DeadLockState)this.mutableToRestore).lockList;
        }

        @Override
        public DeadLockState build() {
            if (this.isFalseState) {
                return null;
            }
            if (this.isRestored) {
                this.mutableToRestore = this.mutableToRestore.toRestore;
            }
            if (DeadLockState.this.lockList.equals(this.mutableLockList) && this.mutableToRestore == DeadLockState.this.toRestore) {
                return DeadLockState.this;
            }
            return new DeadLockState(this.mutableLockList, (DeadLockState)this.mutableToRestore);
        }

        @Override
        public DeadLockState getOldState() {
            return DeadLockState.this;
        }

        @Override
        public void resetAll() {
            this.mutableLockList.clear();
        }

        @Override
        public void reduce(Set<LockIdentifier> removeCounters, Set<LockIdentifier> totalRemove) {
            this.mutableToRestore = null;
            int num = this.getTailNum(this.mutableLockList, removeCounters, totalRemove);
            if (num < this.mutableLockList.size() - 1) {
                for (int i = this.mutableLockList.size() - 1; i > num; --i) {
                    this.mutableLockList.remove(i);
                }
            }
        }

        @Override
        public void expand(AbstractLockState rootState, Set<LockIdentifier> expandCounters, Set<LockIdentifier> totalExpand) {
            this.mutableToRestore = rootState.toRestore;
            List<LockIdentifier> rootList = ((DeadLockState)rootState).lockList;
            int num = this.getTailNum(this.mutableLockList, expandCounters, totalExpand);
            if (num < rootList.size() - 1) {
                for (int i = num + 1; i < rootList.size(); ++i) {
                    this.mutableLockList.add(rootList.get(i));
                }
            }
        }

        private int getTailNum(List<LockIdentifier> pLockList, Set<LockIdentifier> removeCounters, Set<LockIdentifier> totalRemove) {
            for (int i = pLockList.size() - 1; i >= 0; --i) {
                LockIdentifier id = pLockList.get(i);
                if (totalRemove.contains(id) && (pLockList.indexOf(id) != i || !removeCounters.contains(id))) continue;
                return i;
            }
            return 0;
        }

        public void expand(LockState rootState) {
            this.mutableToRestore = rootState.toRestore;
        }

        @Override
        public void setRestoreState() {
            this.mutableToRestore = DeadLockState.this;
        }

        @Override
        public void setAsFalseState() {
            this.isFalseState = true;
        }
    }

    public static class DeadLockTreeNode
    extends ArrayList<LockIdentifier>
    implements CompatibleNode {
        private static final long serialVersionUID = 5757759799394605077L;

        public DeadLockTreeNode(List<LockIdentifier> locks) {
            super(locks);
        }

        @Override
        public int compareTo(CompatibleState pOther) {
            Preconditions.checkArgument((boolean)(pOther instanceof DeadLockTreeNode));
            DeadLockTreeNode o = (DeadLockTreeNode)pOther;
            int result = this.size() - o.size();
            if (result != 0) {
                return result;
            }
            Iterator lockIterator = this.iterator();
            Iterator lockIterator2 = o.iterator();
            while (lockIterator.hasNext()) {
                result = ((LockIdentifier)lockIterator.next()).compareTo((LockIdentifier)lockIterator2.next());
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        @Override
        public boolean cover(CompatibleNode pNode) {
            Preconditions.checkArgument((boolean)(pNode instanceof DeadLockTreeNode));
            return this.compareTo(pNode) == 0;
        }

        @Override
        public boolean hasEmptyLockSet() {
            return this.isEmpty();
        }
    }
}

