/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.lock.DeadLockState;
import org.sosy_lab.cpachecker.cpa.lock.LockPrecision;
import org.sosy_lab.cpachecker.cpa.lock.LockReducer;
import org.sosy_lab.cpachecker.cpa.lock.LockState;
import org.sosy_lab.cpachecker.cpa.lock.LockStopOperator;
import org.sosy_lab.cpachecker.cpa.lock.LockTransferRelation;

@Options(prefix="cpa.lock")
public class LockCPA
extends AbstractCPA
implements ConfigurableProgramAnalysisWithBAM,
StatisticsProvider {
    @Option(description="What are we searching for: race or deadlock", secure=true)
    private LockAnalysisMode analysisMode = LockAnalysisMode.RACE;
    @Option(description="Consider or not special cases with empty lock sets", secure=true)
    private StopMode stopMode = StopMode.DEFAULT;
    @Option(description="Enable refinement procedure", secure=true)
    private boolean refinement = false;
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which merge operator to use for LockCPA")
    private String mergeType = "SEP";
    private final LockReducer reducer;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(LockCPA.class);
    }

    private LockCPA(Configuration config, LogManager logger) throws InvalidConfigurationException {
        super(DelegateAbstractDomain.getInstance(), new LockTransferRelation(config, logger));
        config.inject((Object)this);
        this.reducer = new LockReducer(config);
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition pPartition) {
        switch (this.analysisMode) {
            case RACE: {
                return new LockState();
            }
            case DEADLOCK: {
                return new DeadLockState();
            }
        }
        throw new UnsupportedOperationException("Unsupported analysis mode");
    }

    @Override
    public Precision getInitialPrecision(CFANode node, StateSpacePartition pPartition) throws InterruptedException {
        if (this.refinement) {
            return new LockPrecision();
        }
        return super.getInitialPrecision(node, pPartition);
    }

    @Override
    public MergeOperator getMergeOperator() {
        switch (this.mergeType) {
            case "SEP": {
                return MergeSepOperator.getInstance();
            }
            case "JOIN": {
                return new MergeJoinOperator(this.getAbstractDomain());
            }
        }
        throw new UnsupportedOperationException("Unsupported merge type");
    }

    @Override
    public StopOperator getStopOperator() {
        switch (this.stopMode) {
            case DEFAULT: {
                return this.buildStopOperator("SEP");
            }
            case EMPTYLOCKSET: {
                return new LockStopOperator();
            }
        }
        throw new UnsupportedOperationException("Unsupported stop mode");
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        LockTransferRelation transfer = (LockTransferRelation)this.getTransferRelation();
        pStatsCollection.add(transfer.getStatistics());
        this.reducer.collectStatistics(pStatsCollection);
    }

    public static enum StopMode {
        DEFAULT,
        EMPTYLOCKSET;

    }

    public static enum LockAnalysisMode {
        RACE,
        DEADLOCK;

    }
}

