/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock;

import com.google.common.base.CharMatcher;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifierWithVariable;

public class LockIdentifier
implements Comparable<LockIdentifier> {
    private static Set<LockIdentifier> createdIds;
    private final String name;
    private final LockType type;

    LockIdentifier(String pName, LockType pType) {
        this.name = pName;
        this.type = pType;
    }

    public static LockIdentifier of(String name) {
        return LockIdentifier.of(name, "");
    }

    public static LockIdentifier of(String name, String var) {
        return LockIdentifier.of(name, var, LockType.GLOBAL_LOCK);
    }

    public static LockIdentifier of(String name, String var, LockType type) {
        LockIdentifier newId;
        if (createdIds == null) {
            createdIds = new HashSet<LockIdentifier>();
        }
        if (var.isEmpty()) {
            newId = new LockIdentifier(name, type);
        } else {
            String varName = LockIdentifier.getCleanName(var);
            newId = new LockIdentifierWithVariable(name, varName, type);
        }
        for (LockIdentifier id : createdIds) {
            if (!id.equals(newId)) continue;
            return id;
        }
        createdIds.add(newId);
        return newId;
    }

    public String getName() {
        return this.name;
    }

    private static String getCleanName(String originName) {
        if (originName != null) {
            String newName = CharMatcher.anyOf((CharSequence)"()").removeFrom((CharSequence)originName);
            newName = newName.replaceAll("___\\d*", "");
            return newName;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LockIdentifier other = (LockIdentifier)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(LockIdentifier pO) {
        return this.name.compareTo(pO.name);
    }

    public static enum LockType {
        MUTEX,
        GLOBAL_LOCK,
        LOCAL_LOCK,
        SPINLOCK;


        public String toASTString() {
            return this.name().toLowerCase();
        }
    }
}

