/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AdjustablePrecision;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.cpa.lock.effects.AbstractLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.AcquireLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.SetLockEffect;

public class LockPrecision
implements AdjustablePrecision {
    private final ImmutableSetMultimap<CFANode, LockIdentifier> precision;

    public LockPrecision() {
        this.precision = ImmutableSetMultimap.of();
    }

    public LockPrecision(Iterable<Map.Entry<CFANode, LockIdentifier>> pSet) {
        this.precision = ImmutableSetMultimap.copyOf(pSet);
    }

    @Override
    public AdjustablePrecision add(AdjustablePrecision pOtherPrecision) {
        LockPrecision other = (LockPrecision)pOtherPrecision;
        return new LockPrecision(Iterables.concat((Iterable)other.precision.entries(), (Iterable)this.precision.entries()));
    }

    @Override
    public AdjustablePrecision subtract(AdjustablePrecision pOtherPrecision) {
        LockPrecision other = (LockPrecision)pOtherPrecision;
        return new LockPrecision((Iterable<Map.Entry<CFANode, LockIdentifier>>)Sets.difference((Set)other.precision.entries(), (Set)this.precision.entries()));
    }

    @Override
    public boolean isEmpty() {
        return this.precision.isEmpty();
    }

    public List<AbstractLockEffect> filter(CFANode pNode, List<AbstractLockEffect> pEffects) {
        ImmutableSet ids = this.precision.get((Object)pNode);
        ArrayList<AbstractLockEffect> filteredEffects = new ArrayList<AbstractLockEffect>();
        for (AbstractLockEffect e : pEffects) {
            if ((e instanceof AcquireLockEffect || e instanceof SetLockEffect) && !ids.contains(((LockEffect)e).getAffectedLock())) continue;
            filteredEffects.add(e);
        }
        return filteredEffects;
    }

    int getKeySize() {
        return this.precision.size();
    }

    String getValues() {
        return new HashSet(this.precision.values()).toString();
    }
}

