/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockState;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockStateBuilder;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.lock")
public class LockReducer
implements Reducer,
StatisticsProvider {
    @Option(description="reduce recursive locks to a single access", secure=true)
    private ReduceStrategy reduceLockCounters = ReduceStrategy.BLOCK;
    @Option(description="reduce unused locks", secure=true)
    private boolean reduceUselessLocks = false;
    private final Multimap<CFANode, LockIdentifier> notReducedLocks;
    private final LockReducerStatistics stats;

    public LockReducer(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        if (this.reduceUselessLocks && this.reduceLockCounters == ReduceStrategy.BLOCK) {
            this.reduceLockCounters = ReduceStrategy.NONE;
        }
        this.notReducedLocks = ArrayListMultimap.create();
        this.stats = new LockReducerStatistics();
    }

    @Override
    public AbstractLockState getVariableReducedState(AbstractState pExpandedElement, Block pContext, CFANode pCallNode) {
        assert (pContext.getCallNode().equals(pCallNode));
        AbstractLockState expandedElement = (AbstractLockState)pExpandedElement;
        this.stats.lockReducing.start();
        AbstractLockStateBuilder builder = expandedElement.builder();
        Pair<Set<LockIdentifier>, Set<LockIdentifier>> lockSets = this.getLockSetsFor(expandedElement, pContext);
        Set<LockIdentifier> locksToProcess = lockSets.getFirst();
        Set<LockIdentifier> uselessLocks = lockSets.getSecond();
        builder.reduce(locksToProcess, uselessLocks);
        AbstractLockState reducedState = builder.build();
        assert (this.getVariableExpandedState(pExpandedElement, pContext, reducedState).equals(pExpandedElement));
        this.stats.lockReducing.stop();
        return reducedState;
    }

    @Override
    public AbstractState getVariableExpandedState(AbstractState pRootElement, Block pReducedContext, AbstractState pReducedElement) {
        this.stats.lockExpanding.start();
        AbstractLockState rootElement = (AbstractLockState)pRootElement;
        AbstractLockState reducedElement = (AbstractLockState)pReducedElement;
        AbstractLockStateBuilder builder = reducedElement.builder();
        Pair<Set<LockIdentifier>, Set<LockIdentifier>> lockSets = this.getLockSetsFor(rootElement, pReducedContext);
        Set<LockIdentifier> locksToProcess = lockSets.getFirst();
        Set<LockIdentifier> uselessLocks = lockSets.getSecond();
        builder.expand(rootElement, locksToProcess, uselessLocks);
        this.stats.lockExpanding.stop();
        return builder.build();
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        return pPrecision;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
        return pReducedPrecision;
    }

    @Override
    public Object getHashCodeForState(AbstractState pElementKey, Precision pPrecisionKey) {
        return ((AbstractLockState)pElementKey).getHashCodeForState();
    }

    @Override
    public AbstractState rebuildStateAfterFunctionCall(AbstractState pRootState, AbstractState pEntryState, AbstractState pExpandedState, FunctionExitNode pExitLocation) {
        return pExpandedState;
    }

    public void consider(List<FunctionEntryNode> pStack, LockIdentifier pFId) {
        pStack.forEach(n -> this.notReducedLocks.put(n, (Object)pFId));
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private Pair<Set<LockIdentifier>, Set<LockIdentifier>> getLockSetsFor(AbstractLockState rootState, Block pContext) {
        ImmutableSet locksToProcess = ImmutableSet.of();
        ImmutableSet uselessLocks = ImmutableSet.of();
        switch (this.reduceLockCounters) {
            case BLOCK: {
                locksToProcess = Sets.difference(rootState.getLocks(), (Set)uselessLocks);
                break;
            }
            case ALL: {
                locksToProcess = Sets.difference(rootState.getLocks(), (Set)uselessLocks);
                break;
            }
        }
        return Pair.of(locksToProcess, uselessLocks);
    }

    public static enum ReduceStrategy {
        NONE,
        BLOCK,
        ALL;

    }

    public class LockReducerStatistics
    implements Statistics {
        private StatTimer lockReducing = new StatTimer("Time for reducing locks");
        private StatTimer reduceUselessLocksTimer = new StatTimer("Time for reducing useless locks");
        private StatTimer reduceLockCountersTimer = new StatTimer("Time for reducing lock counters");
        private StatTimer lockExpanding = new StatTimer("Time for expanding locks");
        private StatTimer expandUselessLocksTimer = new StatTimer("Time for expanding useless locks");
        private StatTimer expandLockCountersTimer = new StatTimer("Time for expanding lock counters");

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter.writingStatisticsTo(pOut).put(this.lockReducing).beginLevel().put(this.reduceUselessLocksTimer).put(this.reduceLockCountersTimer).endLevel().put(this.lockExpanding).beginLevel().put(this.expandUselessLocksTimer).put(this.expandLockCountersTimer).endLevel().put("Size of unreducable map", LockReducer.this.notReducedLocks.size());
        }

        @Override
        public @Nullable String getName() {
            return "Lock Reducer";
        }
    }
}

