/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockState;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockStateBuilder;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.cpa.lock.effects.AcquireLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.ReleaseLockEffect;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleNode;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleState;

public final class LockState
extends AbstractLockState {
    private final ImmutableMap<LockIdentifier, Integer> locks;

    public LockState() {
        this.locks = ImmutableMap.of();
    }

    LockState(Map<LockIdentifier, Integer> gLocks, LockState state) {
        super(state);
        this.locks = ImmutableMap.copyOf(gLocks);
    }

    @Override
    public Map<LockIdentifier, Integer> getHashCodeForState() {
        return this.locks;
    }

    @Override
    public String toString() {
        if (this.locks.size() > 0) {
            StringBuilder sb = new StringBuilder();
            return Joiner.on((String)"], ").withKeyValueSeparator("[").appendTo(sb, this.locks).append("]").toString();
        }
        return "Without locks";
    }

    @Override
    public int getCounter(LockIdentifier lock) {
        return (Integer)this.locks.getOrDefault((Object)lock, (Object)0);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.locks);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LockState other = (LockState)obj;
        return Objects.equals(this.toRestore, other.toRestore) && Objects.equals(this.locks, other.locks);
    }

    @Override
    public int compareTo(CompatibleState pOther) {
        LockState other = (LockState)pOther;
        int result = other.getSize() - this.getSize();
        if (result != 0) {
            return result;
        }
        UnmodifiableIterator iterator1 = this.locks.entrySet().iterator();
        UnmodifiableIterator iterator2 = other.locks.entrySet().iterator();
        while (iterator1.hasNext()) {
            Map.Entry entry1 = (Map.Entry)iterator1.next();
            Map.Entry entry2 = (Map.Entry)iterator2.next();
            result = ((LockIdentifier)entry1.getKey()).compareTo((LockIdentifier)entry2.getKey());
            if (result != 0) {
                return result;
            }
            Integer Result2 = (Integer)entry1.getValue() - (Integer)entry2.getValue();
            if (Result2 == 0) continue;
            return Result2;
        }
        return 0;
    }

    @Override
    public LockStateBuilder builder() {
        return new LockStateBuilder(this);
    }

    @Override
    public Multiset<LockEffect> getDifference(AbstractLockState pOther) {
        LockIdentifier lockId;
        LockState other = (LockState)pOther;
        HashMultiset result = HashMultiset.create();
        TreeSet<LockIdentifier> processedLocks = new TreeSet<LockIdentifier>();
        for (Map.Entry entry : this.locks.entrySet()) {
            int i;
            int otherCounter;
            lockId = (LockIdentifier)entry.getKey();
            int thisCounter = (Integer)entry.getValue();
            if (thisCounter > (otherCounter = ((Integer)other.locks.getOrDefault((Object)lockId, (Object)0)).intValue())) {
                for (i = 0; i < thisCounter - otherCounter; ++i) {
                    result.add((Object)ReleaseLockEffect.createEffectForId(lockId));
                }
            } else if (thisCounter < otherCounter) {
                for (i = 0; i < otherCounter - thisCounter; ++i) {
                    result.add((Object)AcquireLockEffect.createEffectForId(lockId));
                }
            }
            processedLocks.add(lockId);
        }
        for (Map.Entry entry : other.locks.entrySet()) {
            lockId = (LockIdentifier)entry.getKey();
            if (processedLocks.contains(lockId)) continue;
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                result.add((Object)AcquireLockEffect.createEffectForId(lockId));
            }
        }
        return result;
    }

    @Override
    public CompatibleState prepareToStore() {
        return this;
    }

    @Override
    public CompatibleNode getCompatibleNode() {
        return new LockTreeNode((Set<LockIdentifier>)this.locks.keySet());
    }

    @Override
    protected Set<LockIdentifier> getLocks() {
        return this.locks.keySet();
    }

    @Override
    public boolean isLessOrEqual(AbstractLockState other) {
        for (LockIdentifier lock : other.getLocks()) {
            if (this.locks.containsKey((Object)lock)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AbstractLockState join(AbstractLockState pOther) {
        TreeMap<LockIdentifier, Integer> overlappedMap = new TreeMap<LockIdentifier, Integer>();
        ImmutableMap<LockIdentifier, Integer> otherMap = ((LockState)pOther).locks;
        for (Map.Entry entry : this.locks.entrySet()) {
            LockIdentifier id = (LockIdentifier)entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (!otherMap.containsKey(id)) continue;
            Integer otherVal = (Integer)otherMap.get(id);
            overlappedMap.put(id, Integer.min(value, otherVal));
        }
        return new LockState(overlappedMap, (LockState)this.toRestore);
    }

    public class LockStateBuilder
    extends AbstractLockStateBuilder {
        private Map<LockIdentifier, Integer> mutableLocks;
        private boolean changed;

        public LockStateBuilder(LockState state) {
            super(state);
            this.mutableLocks = state.locks;
            this.changed = false;
        }

        public void cloneIfNecessary() {
            if (!this.changed) {
                this.changed = true;
                this.mutableLocks = new TreeMap<LockIdentifier, Integer>(this.mutableLocks);
            }
        }

        @Override
        public void add(LockIdentifier lockId) {
            this.cloneIfNecessary();
            Integer a = this.mutableLocks.getOrDefault(lockId, 0) + 1;
            this.mutableLocks.put(lockId, a);
        }

        @Override
        public void free(LockIdentifier lockId) {
            if (this.mutableLocks.containsKey(lockId)) {
                Integer a = this.mutableLocks.get(lockId) - 1;
                this.cloneIfNecessary();
                if (a > 0) {
                    this.mutableLocks.put(lockId, a);
                } else {
                    this.mutableLocks.remove(lockId);
                }
            }
        }

        @Override
        public void reset(LockIdentifier lockId) {
            this.cloneIfNecessary();
            this.mutableLocks.remove(lockId);
        }

        @Override
        public void set(LockIdentifier lockId, int num) {
            block4: {
                Integer size;
                block3: {
                    size = this.mutableLocks.get(lockId);
                    if (size == null) {
                        size = 0;
                    }
                    if (num <= size) break block3;
                    for (int i = 0; i < num - size; ++i) {
                        this.add(lockId);
                    }
                    break block4;
                }
                if (num >= size) break block4;
                for (int i = 0; i < size - num; ++i) {
                    this.free(lockId);
                }
            }
        }

        @Override
        public void restore(LockIdentifier lockId) {
            if (this.mutableToRestore == null) {
                return;
            }
            Integer size = (Integer)((LockState)this.mutableToRestore).locks.get((Object)lockId);
            this.cloneIfNecessary();
            this.mutableLocks.remove(lockId);
            if (size != null) {
                this.mutableLocks.put(lockId, size);
            }
            this.isRestored = true;
        }

        @Override
        public void restoreAll() {
            this.mutableLocks = ((LockState)this.mutableToRestore).locks;
        }

        @Override
        public LockState build() {
            if (this.isFalseState) {
                return null;
            }
            if (this.isRestored) {
                this.mutableToRestore = this.mutableToRestore.toRestore;
            }
            if (LockState.this.locks.equals(this.mutableLocks) && this.mutableToRestore == LockState.this.toRestore) {
                return LockState.this;
            }
            return new LockState(this.mutableLocks, (LockState)this.mutableToRestore);
        }

        @Override
        public LockState getOldState() {
            return LockState.this;
        }

        @Override
        public void resetAll() {
            this.cloneIfNecessary();
            this.mutableLocks.clear();
        }

        @Override
        public void reduce(Set<LockIdentifier> removeCounters, Set<LockIdentifier> totalRemove) {
            this.mutableToRestore = null;
            assert (Sets.intersection(removeCounters, totalRemove).isEmpty());
            this.cloneIfNecessary();
            removeCounters.forEach(l -> this.mutableLocks.replace((LockIdentifier)l, 1));
            Iterator<Map.Entry<LockIdentifier, Integer>> iterator = this.mutableLocks.entrySet().iterator();
            while (iterator.hasNext()) {
                LockIdentifier lockId = iterator.next().getKey();
                if (!totalRemove.contains(lockId)) continue;
                iterator.remove();
            }
        }

        @Override
        public void expand(AbstractLockState rootState, Set<LockIdentifier> expandCounters, Set<LockIdentifier> totalExpand) {
            this.mutableToRestore = rootState.toRestore;
            assert (Sets.intersection(expandCounters, totalExpand).isEmpty());
            this.cloneIfNecessary();
            ImmutableMap<LockIdentifier, Integer> rootLocks = ((LockState)rootState).locks;
            for (LockIdentifier lock : expandCounters) {
                if (!rootLocks.containsKey(lock)) continue;
                Integer size = this.mutableLocks.get(lock);
                Integer rootSize = (Integer)rootLocks.get(lock);
                this.cloneIfNecessary();
                Integer newSize = size == null ? Integer.valueOf(rootSize - 1) : Integer.valueOf(size + rootSize - 1);
                if (newSize > 0) {
                    this.mutableLocks.put(lock, newSize);
                    continue;
                }
                this.mutableLocks.remove(lock);
            }
            for (LockIdentifier lockId : totalExpand) {
                if (!rootLocks.containsKey(lockId)) continue;
                this.mutableLocks.put(lockId, (Integer)rootLocks.get(lockId));
            }
        }

        @Override
        public void setRestoreState() {
            this.mutableToRestore = LockState.this;
        }

        @Override
        public void setAsFalseState() {
            this.isFalseState = true;
        }
    }

    public static class LockTreeNode
    extends TreeSet<LockIdentifier>
    implements CompatibleNode {
        private static final long serialVersionUID = 5757759799394605077L;

        public LockTreeNode(Set<LockIdentifier> locks) {
            super(locks);
        }

        @Override
        public boolean isCompatibleWith(CompatibleState pState) {
            Preconditions.checkArgument((boolean)(pState instanceof LockTreeNode));
            return Sets.intersection((Set)this, (Set)((LockTreeNode)pState)).isEmpty();
        }

        @Override
        public int compareTo(CompatibleState pOther) {
            Preconditions.checkArgument((boolean)(pOther instanceof LockTreeNode));
            LockTreeNode o = (LockTreeNode)pOther;
            int result = this.size() - o.size();
            if (result != 0) {
                return result;
            }
            Iterator lockIterator = this.iterator();
            Iterator lockIterator2 = o.iterator();
            while (lockIterator.hasNext()) {
                result = ((LockIdentifier)lockIterator.next()).compareTo((LockIdentifier)lockIterator2.next());
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        @Override
        public boolean cover(CompatibleNode pNode) {
            Preconditions.checkArgument((boolean)(pNode instanceof LockTreeNode));
            LockTreeNode o = (LockTreeNode)pNode;
            if (this.isEmpty()) {
                return o.isEmpty();
            }
            return o.containsAll(this);
        }

        @Override
        public boolean hasEmptyLockSet() {
            return this.isEmpty();
        }
    }
}

