/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockState;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockStateBuilder;
import org.sosy_lab.cpachecker.cpa.lock.AnnotationInfo;
import org.sosy_lab.cpachecker.cpa.lock.ConfigurationParser;
import org.sosy_lab.cpachecker.cpa.lock.LockIdUnprepared;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.cpa.lock.LockInfo;
import org.sosy_lab.cpachecker.cpa.lock.LockPrecision;
import org.sosy_lab.cpachecker.cpa.lock.effects.AbstractLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.AcquireLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.CheckLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.ReleaseLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.ResetLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.RestoreAllLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.RestoreLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.SaveStateLockEffect;
import org.sosy_lab.cpachecker.cpa.lock.effects.SetLockEffect;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.IdentifierCreator;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.lock")
public class LockTransferRelation
extends SingleEdgeTransferRelation {
    private final Map<String, AnnotationInfo> annotatedFunctions;
    private final LockInfo lockDescription;
    private final LogManager logger;
    private final LockStatistics stats;
    @Option(name="stopAfterLockLimit", description="stop path exploration if a lock limit is reached", secure=true)
    private boolean stopAfterLockLimit = false;

    public LockTransferRelation(Configuration config, LogManager logger) throws InvalidConfigurationException {
        this.logger = logger;
        config.inject((Object)this);
        ConfigurationParser parser = new ConfigurationParser(config);
        this.lockDescription = parser.parseLockInfo();
        this.annotatedFunctions = parser.parseAnnotatedFunctions();
        assert (this.annotatedFunctions != null);
        this.stats = new LockStatistics();
    }

    public Collection<AbstractLockState> getAbstractSuccessorsForEdge(AbstractState element, Precision pPrecision, CFAEdge cfaEdge) throws UnrecognizedCodeException {
        AbstractLockState lockStatisticsElement = (AbstractLockState)element;
        this.stats.transferTimer.start();
        this.stats.operationsTimer.start();
        List<AbstractLockEffect> toProcess = this.determineOperations(cfaEdge);
        this.stats.lockEffects.setNextValue(toProcess.size());
        this.stats.operationsTimer.stop();
        if (!(pPrecision instanceof SingletonPrecision)) {
            LockPrecision lockPrecision = (LockPrecision)pPrecision;
            this.stats.filteringTimer.start();
            toProcess = lockPrecision.filter(cfaEdge.getPredecessor(), toProcess);
            this.stats.filteringTimer.stop();
        }
        this.stats.applyTimer.start();
        AbstractLockState successor = this.applyEffects(lockStatisticsElement, toProcess);
        this.stats.applyTimer.stop();
        this.stats.transferTimer.stop();
        if (successor != null) {
            int locks = successor.getSize();
            this.stats.locksInState.setNextValue(locks);
            if (locks > 0) {
                this.stats.locksInStateWithLocks.setNextValue(locks);
            }
            return Collections.singleton(successor);
        }
        return ImmutableSet.of();
    }

    public AbstractLockState applyEffects(AbstractLockState oldState, List<AbstractLockEffect> toProcess) {
        AbstractLockStateBuilder builder = oldState.builder();
        toProcess.forEach(e -> e.effect(builder));
        return builder.build();
    }

    public Set<LockIdentifier> getAffectedLocks(CFAEdge cfaEdge) {
        return this.getLockEffects(cfaEdge).transform(LockEffect::getAffectedLock).toSet();
    }

    public FluentIterable<LockEffect> getLockEffects(CFAEdge cfaEdge) {
        try {
            return FluentIterable.from(this.determineOperations(cfaEdge)).filter(LockEffect.class);
        }
        catch (UnrecognizedCodeException e) {
            this.logger.log(Level.WARNING, new Object[]{"The code " + cfaEdge + " is not recognized"});
            return FluentIterable.of();
        }
    }

    public List<AbstractLockEffect> determineOperations(CFAEdge cfaEdge) throws UnrecognizedCodeException {
        switch (cfaEdge.getEdgeType()) {
            case FunctionCallEdge: {
                return this.handleFunctionCall((CFunctionCallEdge)cfaEdge);
            }
            case FunctionReturnEdge: {
                return this.handleFunctionReturnEdge((CFunctionReturnEdge)cfaEdge);
            }
            case StatementEdge: {
                return this.handleStatement((CStatementEdge)cfaEdge);
            }
            case AssumeEdge: {
                return this.handleAssumption((CAssumeEdge)cfaEdge);
            }
            case BlankEdge: 
            case ReturnStatementEdge: 
            case DeclarationEdge: 
            case CallToReturnEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCodeException("Unknown edge type", cfaEdge);
            }
        }
        return ImmutableList.of();
    }

    private List<AbstractLockEffect> handleAssumption(CAssumeEdge cfaEdge) {
        CExpression assumption = cfaEdge.getExpression();
        if (assumption instanceof CBinaryExpression) {
            CBinaryExpression binExpression = (CBinaryExpression)assumption;
            IdentifierCreator creator = new IdentifierCreator(cfaEdge.getSuccessor().getFunctionName());
            AbstractIdentifier varId = creator.createIdentifier(binExpression.getOperand1(), 0);
            if (varId instanceof SingleIdentifier) {
                CExpression val;
                String varName = ((SingleIdentifier)varId).getName();
                if (this.lockDescription.getVariableEffectDescription().containsKey((Object)varName) && (val = binExpression.getOperand2()) instanceof CIntegerLiteralExpression) {
                    if (binExpression.getOperator() == CBinaryExpression.BinaryOperator.EQUALS) {
                        LockIdentifier id = (LockIdentifier)this.lockDescription.getVariableEffectDescription().get((Object)varName);
                        int level = ((CIntegerLiteralExpression)val).getValue().intValue();
                        CheckLockEffect e = CheckLockEffect.createEffectForId(level, cfaEdge.getTruthAssumption(), id);
                        return Collections.singletonList(e);
                    }
                    this.logger.log(Level.WARNING, new Object[]{"Unknown binary operator " + binExpression.getOperator() + ", skip it"});
                }
            }
        }
        return ImmutableList.of();
    }

    private ImmutableList<? extends AbstractLockEffect> convertAnnotationToLockEffect(Set<LockIdentifier> pAnnotatedIds, LockEffect pEffect) {
        return Collections3.transformedImmutableListCopy(pAnnotatedIds, pEffect::cloneWithTarget);
    }

    private List<AbstractLockEffect> handleFunctionReturnEdge(CFunctionReturnEdge cfaEdge) {
        String fName = cfaEdge.getSummaryEdge().getExpression().getFunctionCallExpression().getFunctionNameExpression().toASTString();
        if (this.annotatedFunctions.containsKey(fName)) {
            ImmutableList.Builder result = ImmutableList.builder();
            AnnotationInfo currentAnnotation = this.annotatedFunctions.get(fName);
            if (currentAnnotation.getRestoreLocks().isEmpty() && currentAnnotation.getFreeLocks().isEmpty() && currentAnnotation.getResetLocks().isEmpty() && currentAnnotation.getCaptureLocks().isEmpty()) {
                RestoreAllLockEffect restoreAll = RestoreAllLockEffect.getInstance();
                return Collections.singletonList(restoreAll);
            }
            if (!currentAnnotation.getRestoreLocks().isEmpty()) {
                result.addAll(this.convertAnnotationToLockEffect((Set<LockIdentifier>)currentAnnotation.getRestoreLocks(), RestoreLockEffect.getInstance()));
            }
            if (!currentAnnotation.getFreeLocks().isEmpty()) {
                result.addAll(this.convertAnnotationToLockEffect((Set<LockIdentifier>)currentAnnotation.getFreeLocks(), ReleaseLockEffect.getInstance()));
            }
            if (!currentAnnotation.getResetLocks().isEmpty()) {
                result.addAll(this.convertAnnotationToLockEffect((Set<LockIdentifier>)currentAnnotation.getResetLocks(), ResetLockEffect.getInstance()));
            }
            if (!currentAnnotation.getCaptureLocks().isEmpty()) {
                for (LockIdentifier targetId : currentAnnotation.getCaptureLocks()) {
                    result.add((Object)AcquireLockEffect.createEffectForId(targetId, this.lockDescription.getMaxLevel(targetId.getName()), this.stopAfterLockLimit));
                }
            }
            return result.build();
        }
        return ImmutableList.of();
    }

    private List<AbstractLockEffect> handleFunctionCallExpression(CFunctionCallExpression function) {
        String functionName = function.getFunctionNameExpression().toASTString();
        if (!this.lockDescription.getFunctionEffectDescription().containsKey((Object)functionName)) {
            return ImmutableList.of();
        }
        Pair locksWithEffect = (Pair)this.lockDescription.getFunctionEffectDescription().get((Object)functionName);
        LockEffect effect = (LockEffect)locksWithEffect.getFirst();
        LockIdUnprepared uId = (LockIdUnprepared)locksWithEffect.getSecond();
        ImmutableList.Builder result = ImmutableList.builder();
        if (effect == SetLockEffect.getInstance()) {
            CExpression expression = function.getParameterExpressions().get(0);
            if (expression instanceof CIntegerLiteralExpression) {
                int newValue = ((CIntegerLiteralExpression)expression).getValue().intValue();
                int max = this.lockDescription.getMaxLevel(uId.getName());
                if (max < newValue) {
                    newValue = max;
                }
                effect = SetLockEffect.createEffectForId(newValue, uId.apply(null));
            } else {
                return result.build();
            }
        }
        LockIdentifier id = uId.apply(function.getParameterExpressions());
        effect = effect == AcquireLockEffect.getInstance() ? AcquireLockEffect.createEffectForId(id, this.lockDescription.getMaxLevel(uId.getName()), this.stopAfterLockLimit) : effect.cloneWithTarget(id);
        result.add((Object)effect);
        return result.build();
    }

    private List<AbstractLockEffect> handleStatement(CStatementEdge statementEdge) {
        CStatement statement = statementEdge.getStatement();
        if (statement instanceof CAssignment) {
            CRightHandSide op2 = ((CAssignment)statement).getRightHandSide();
            if (op2 instanceof CFunctionCallExpression) {
                CFunctionCallExpression function = (CFunctionCallExpression)op2;
                return this.handleFunctionCallExpression(function);
            }
            CLeftHandSide leftSide = ((CAssignment)statement).getLeftHandSide();
            CRightHandSide rightSide = ((CAssignment)statement).getRightHandSide();
            IdentifierCreator creator = new IdentifierCreator(statementEdge.getSuccessor().getFunctionName());
            AbstractIdentifier varId = creator.createIdentifier(leftSide, 0);
            if (varId instanceof SingleIdentifier) {
                String varName = ((SingleIdentifier)varId).getName();
                if (this.lockDescription.getVariableEffectDescription().containsKey((Object)varName) && rightSide instanceof CIntegerLiteralExpression) {
                    LockIdentifier id = (LockIdentifier)this.lockDescription.getVariableEffectDescription().get((Object)varName);
                    int level = ((CIntegerLiteralExpression)rightSide).getValue().intValue();
                    SetLockEffect e = SetLockEffect.createEffectForId(level, id);
                    return Collections.singletonList(e);
                }
            }
        } else if (statement instanceof CFunctionCallStatement) {
            CFunctionCallStatement funcStatement = (CFunctionCallStatement)statement;
            return this.handleFunctionCallExpression(funcStatement.getFunctionCallExpression());
        }
        return ImmutableList.of();
    }

    private List<AbstractLockEffect> handleFunctionCall(CFunctionCallEdge callEdge) {
        ArrayList<AbstractLockEffect> result = new ArrayList<AbstractLockEffect>();
        if (this.annotatedFunctions.containsKey(callEdge.getSuccessor().getFunctionName())) {
            SaveStateLockEffect saveState = SaveStateLockEffect.getInstance();
            result.add(saveState);
        }
        result.addAll(this.handleFunctionCallExpression(callEdge.getSummaryEdge().getExpression().getFunctionCallExpression()));
        return result;
    }

    public String doesChangeTheState(CFAEdge pEdge) {
        return this.getLockEffects(pEdge).join(Joiner.on((String)","));
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public static class LockStatistics
    implements Statistics {
        private final StatTimer transferTimer = new StatTimer("Time for transfer");
        private final StatTimer operationsTimer = new StatTimer("Time for extracting effects");
        private final StatTimer filteringTimer = new StatTimer("Time for filtering effects");
        private final StatTimer applyTimer = new StatTimer("Time for applying effects");
        private final StatInt lockEffects = new StatInt(StatKind.SUM, "Number of effects");
        private final StatInt locksInState = new StatInt(StatKind.AVG, "Number of locks in state");
        private final StatInt locksInStateWithLocks = new StatInt(StatKind.AVG, "Number of locks in state with locks");

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter w = StatisticsWriter.writingStatisticsTo(pOut).put(this.transferTimer).beginLevel().put(this.operationsTimer).put(this.filteringTimer).put(this.applyTimer).endLevel().put(this.lockEffects).put(this.locksInState).put(this.locksInStateWithLocks);
            Precision p = pReached.getPrecision(pReached.getFirstState());
            LockPrecision lockPrecision = Precisions.extractPrecisionByType(p, LockPrecision.class);
            if (lockPrecision != null) {
                w.put("Number of considered lock operations", lockPrecision.getKeySize()).put("Considered lock identifiers", lockPrecision.getValues());
            }
        }

        @Override
        public @Nullable String getName() {
            return "LockCPA";
        }
    }
}

