/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock.effects;

import com.google.common.base.Preconditions;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockStateBuilder;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;

public class AcquireLockEffect
extends LockEffect {
    private static final AcquireLockEffect instance = new AcquireLockEffect();
    private static final NavigableMap<LockIdentifier, AcquireLockEffect> AcquireLockEffectMap = new TreeMap<LockIdentifier, AcquireLockEffect>();
    protected final int maxRecursiveCounter;

    private AcquireLockEffect(LockIdentifier id, int t) {
        super(id);
        this.maxRecursiveCounter = t;
    }

    private AcquireLockEffect() {
        this(null, Integer.MAX_VALUE);
    }

    @Override
    public void effect(AbstractLockStateBuilder pBuilder) {
        Preconditions.checkArgument((this.target != null ? 1 : 0) != 0, (Object)"Lock identifier must be set");
        int previousP = pBuilder.getOldState().getCounter(this.target);
        if (this.maxRecursiveCounter > previousP) {
            pBuilder.add(this.target);
        }
    }

    public static AcquireLockEffect getInstance() {
        return instance;
    }

    public static AcquireLockEffect createEffectForId(LockIdentifier id, int counter, boolean stop) {
        AcquireLockEffect result;
        if (AcquireLockEffectMap.containsKey(id)) {
            result = (AcquireLockEffect)AcquireLockEffectMap.get(id);
            Preconditions.checkArgument((result.maxRecursiveCounter == counter ? 1 : 0) != 0, (String)"Recursive counter differs for %s", (Object)id);
        } else {
            result = stop ? new StopAcquireLockEffect(id, counter) : new AcquireLockEffect(id, counter);
            AcquireLockEffectMap.put(id, result);
        }
        return result;
    }

    public static AcquireLockEffect createEffectForId(LockIdentifier id) {
        if (AcquireLockEffectMap.containsKey(id)) {
            return (AcquireLockEffect)AcquireLockEffectMap.get(id);
        }
        return new AcquireLockEffect(id, Integer.MAX_VALUE);
    }

    @Override
    public AcquireLockEffect cloneWithTarget(LockIdentifier id) {
        return AcquireLockEffect.createEffectForId(id, this.maxRecursiveCounter, false);
    }

    @Override
    public String getAction() {
        return "Acquire";
    }

    private static final class StopAcquireLockEffect
    extends AcquireLockEffect {
        private StopAcquireLockEffect(LockIdentifier id, int t) {
            super(id, t);
        }

        @Override
        public void effect(AbstractLockStateBuilder pBuilder) {
            Preconditions.checkArgument((this.target != null ? 1 : 0) != 0, (Object)"Lock identifier must be set");
            int previousP = pBuilder.getOldState().getCounter(this.target);
            if (this.maxRecursiveCounter > previousP) {
                pBuilder.add(this.target);
            } else {
                pBuilder.setAsFalseState();
            }
        }

        @Override
        public AcquireLockEffect cloneWithTarget(LockIdentifier id) {
            return StopAcquireLockEffect.createEffectForId(id, this.maxRecursiveCounter, true);
        }
    }
}

