/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.lock.effects;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockStateBuilder;
import org.sosy_lab.cpachecker.cpa.lock.LockIdentifier;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;

public final class CheckLockEffect
extends LockEffect {
    private static final CheckLockEffect instance = new CheckLockEffect();
    final boolean isTruth;
    final int p;

    private CheckLockEffect(int t, boolean truth, LockIdentifier id) {
        super(id);
        this.p = t;
        this.isTruth = truth;
    }

    private CheckLockEffect() {
        this(0, true, null);
    }

    @Override
    public void effect(AbstractLockStateBuilder pBuilder) {
        boolean result;
        Preconditions.checkArgument((this != instance ? 1 : 0) != 0, (Object)"Temporary instance can not effect");
        Preconditions.checkArgument((this.target != null ? 1 : 0) != 0, (Object)"Lock identifier must be set");
        int previousP = pBuilder.getOldState().getCounter(this.target);
        boolean bl = result = previousP == this.p == this.isTruth;
        if (!result) {
            pBuilder.setAsFalseState();
        }
    }

    public static CheckLockEffect getInstance() {
        return instance;
    }

    public static CheckLockEffect createEffectForId(int t, boolean truth, LockIdentifier id) {
        return new CheckLockEffect(t, truth, id);
    }

    @Override
    public CheckLockEffect cloneWithTarget(LockIdentifier id) {
        return CheckLockEffect.createEffectForId(this.p, this.isTruth, id);
    }

    @Override
    public String getAction() {
        return "Check";
    }
}

