/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopbound;

import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.LoopIterationBounding;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.conditions.ReachedSetAdjustingCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundPrecision;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundState;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundTransferRelation;
import org.sosy_lab.cpachecker.cpa.loopbound.ModularStopOperator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.loopbound")
public class LoopBoundCPA
extends AbstractCPA
implements ReachedSetAdjustingCPA,
StatisticsProvider,
Statistics,
LoopIterationBounding {
    @Option(secure=true, description="enable stack-based tracking of loops")
    private boolean trackStack = false;
    @Option(secure=true, description="Use a stop operator that will identify loop states who's depth is congruent regarding the modulus of this number. Values smaller or equal to zero will deactivate this feature.")
    private int cyclicStopModulus = -1;
    private final LoopStructure loopStructure;
    private final LoopBoundPrecisionAdjustment precisionAdjustment;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(LoopBoundCPA.class);
    }

    LoopBoundCPA(Configuration pConfig, CFA pCFA, LogManager pLogger) throws InvalidConfigurationException, CPAException {
        super("sep", "sep", new LoopBoundTransferRelation(pConfig, pCFA));
        pConfig.inject((Object)this);
        this.loopStructure = pCFA.getLoopStructure().orElseThrow();
        this.precisionAdjustment = new LoopBoundPrecisionAdjustment(pConfig, pLogger);
    }

    @Override
    public StopOperator getStopOperator() {
        if (this.cyclicStopModulus <= 0) {
            return super.getStopOperator();
        }
        return new ModularStopOperator(this.cyclicStopModulus);
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        LoopBoundState initialState = new LoopBoundState();
        for (LoopStructure.Loop loop : this.loopStructure.getLoopsForLoopHead(pNode)) {
            initialState = initialState.visitLoopHead(loop);
        }
        return initialState;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return new LoopBoundPrecision(this.trackStack, this.precisionAdjustment.getMaxLoopIterations(), this.precisionAdjustment.getLoopIterationsBeforeAbstraction());
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public boolean adjustPrecision() {
        return this.precisionAdjustment.nextState();
    }

    @Override
    public void adjustReachedSet(ReachedSet pReachedSet) {
        LinkedHashSet<AbstractState> toRemove = new LinkedHashSet<AbstractState>();
        for (AbstractState s : pReachedSet) {
            LoopBoundState loopBoundState = AbstractStates.extractStateByType(s, LoopBoundState.class);
            if (loopBoundState == null || !loopBoundState.mustDumpAssumptionForAvoidance()) continue;
            toRemove.add(s);
        }
        if (toRemove.contains(pReachedSet.getFirstState())) {
            pReachedSet.clear();
            return;
        }
        LinkedHashSet<ARGState> waitlist = new LinkedHashSet<ARGState>();
        for (ARGState s : AbstractStates.projectToType(toRemove, ARGState.class)) {
            waitlist.addAll(s.getParents());
        }
        waitlist.forEach(pReachedSet::reAddToWaitlist);
        pReachedSet.removeAll(toRemove);
        for (ARGState s : AbstractStates.projectToType(toRemove, ARGState.class)) {
            s.removeFromARG();
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this);
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
        writer.put("Bound k", this.precisionAdjustment.getMaxLoopIterations());
        int maximumLoopIterationReached = 0;
        for (LoopBoundState state : AbstractStates.projectToType(pReached, LoopBoundState.class)) {
            maximumLoopIterationReached = Math.max(maximumLoopIterationReached, state.getDeepestIteration());
        }
        writer.put("Maximum loop iteration reached", maximumLoopIterationReached);
        writer.spacer();
    }

    @Override
    public String getName() {
        return "Bounds CPA";
    }

    @Override
    public void setMaxLoopIterations(int pMaxLoopIterations) {
        this.precisionAdjustment.setMaxLoopIterations(pMaxLoopIterations);
    }

    @Override
    public int getMaxLoopIterations() {
        return this.precisionAdjustment.getMaxLoopIterations();
    }

    public void incrementLoopIterationsBeforeAbstraction() {
        this.precisionAdjustment.incrementLoopIterationsBeforeAbstraction();
    }
}

