/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopbound;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.core.interfaces.Precision;

public class LoopBoundPrecision
implements Precision {
    private final boolean trackStack;
    private final int maxLoopIterations;
    private final int loopIterationsBeforeAbstraction;

    LoopBoundPrecision(boolean pStack, int pMaxLoopIterations, int pLoopIterationsBeforeAbstraction) {
        Preconditions.checkArgument((pMaxLoopIterations >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((pLoopIterationsBeforeAbstraction >= 0 ? 1 : 0) != 0);
        this.trackStack = pStack;
        this.maxLoopIterations = pMaxLoopIterations;
        this.loopIterationsBeforeAbstraction = pLoopIterationsBeforeAbstraction;
    }

    boolean shouldTrackStack() {
        return this.trackStack;
    }

    int getMaxLoopIterations() {
        return this.maxLoopIterations;
    }

    int getLoopIterationsBeforeAbstraction() {
        return this.loopIterationsBeforeAbstraction;
    }

    LoopBoundPrecision withMaxLoopIterations(int pMaxLoopIterations) {
        if (pMaxLoopIterations == this.maxLoopIterations) {
            return this;
        }
        return new LoopBoundPrecision(this.trackStack, pMaxLoopIterations, this.loopIterationsBeforeAbstraction);
    }

    LoopBoundPrecision withLoopIterationsBeforeAbstraction(int pLoopIterationsBeforeAbstraction) {
        if (pLoopIterationsBeforeAbstraction == this.loopIterationsBeforeAbstraction) {
            return this;
        }
        return new LoopBoundPrecision(this.trackStack, this.maxLoopIterations, pLoopIterationsBeforeAbstraction);
    }

    public String toString() {
        return "k = " + this.maxLoopIterations + ", " + (this.shouldTrackStack() ? "track loop stack" : "do not track loop stack");
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof LoopBoundPrecision) {
            LoopBoundPrecision other = (LoopBoundPrecision)pOther;
            return this.trackStack == other.trackStack && this.maxLoopIterations == other.maxLoopIterations;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.trackStack, this.maxLoopIterations);
    }
}

