/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopbound;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundPrecision;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.loopbound")
public class LoopBoundPrecisionAdjustment
implements PrecisionAdjustment {
    @Option(secure=true, description="threshold for unrolling loops of the program (0 is infinite)\nworks only if assumption storage CPA is enabled, because otherwise it would be unsound")
    private int maxLoopIterations = 0;
    @Option(secure=true, description="threshold for adjusting the threshold for unrolling loops of the program (0 is infinite).\nonly relevant in combination with a non-static maximum loop iteration adjuster.")
    private int maxLoopIterationsUpperBound = 0;
    @Option(secure=true, description="this option controls how the maxLoopIterations condition is adjusted when a condition adjustment is invoked.")
    private MaxLoopIterationAdjusters maxLoopIterationAdjusterFactory = MaxLoopIterationAdjusters.STATIC;
    @Option(secure=true, description="Number of loop iterations before the loop counter is abstracted. Zero is equivalent to no limit.")
    private int loopIterationsBeforeAbstraction = 0;
    private final LogManager logger;

    public LoopBoundPrecisionAdjustment(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        if (this.maxLoopIterations < 0) {
            throw new InvalidConfigurationException("cpa.loopbound.maxLoopIterations must be a non-negative value, but is set to " + this.maxLoopIterations);
        }
        this.logger = pLogger;
    }

    int getMaxLoopIterations() {
        return this.maxLoopIterations;
    }

    void setMaxLoopIterations(int pMaxLoopIterations) {
        Preconditions.checkArgument((pMaxLoopIterations >= 0 ? 1 : 0) != 0);
        this.maxLoopIterations = pMaxLoopIterations;
    }

    int getLoopIterationsBeforeAbstraction() {
        return this.loopIterationsBeforeAbstraction == 0 ? Integer.MAX_VALUE : this.loopIterationsBeforeAbstraction;
    }

    private void setLoopIterationsBeforeAbstraction(int pLoopIterationsBeforeAbstraction) {
        Preconditions.checkArgument((pLoopIterationsBeforeAbstraction >= 0 ? 1 : 0) != 0);
        this.loopIterationsBeforeAbstraction = pLoopIterationsBeforeAbstraction;
    }

    void incrementLoopIterationsBeforeAbstraction() {
        this.setLoopIterationsBeforeAbstraction(this.getLoopIterationsBeforeAbstraction() + 1);
    }

    public String toString() {
        return "k = " + this.maxLoopIterations + ", adjustment strategy = " + this.maxLoopIterationAdjusterFactory;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) throws CPAException, InterruptedException {
        LoopBoundPrecision precision = (LoopBoundPrecision)pPrecision;
        LoopBoundPrecision adjustedPrecision = precision.withMaxLoopIterations(this.maxLoopIterations).withLoopIterationsBeforeAbstraction(this.getLoopIterationsBeforeAbstraction());
        LoopBoundState state = (LoopBoundState)pState;
        LoopBoundState adjustedState = state.setStop(this.maxLoopIterations > 0 && state.getDeepestIteration() > this.maxLoopIterations).enforceAbstraction(this.getLoopIterationsBeforeAbstraction());
        PrecisionAdjustmentResult result = PrecisionAdjustmentResult.create(adjustedState, adjustedPrecision, PrecisionAdjustmentResult.Action.CONTINUE);
        return Optional.of(result);
    }

    public boolean nextState() {
        MaxLoopIterationAdjuster maxLoopIterationAdjuster = this.maxLoopIterationAdjusterFactory.getMaxLoopIterationAdjuster(this);
        if (maxLoopIterationAdjuster.canAdjust(this.getMaxLoopIterations())) {
            int adjustedMaxLoopIterations = maxLoopIterationAdjuster.adjust(this.getMaxLoopIterations());
            this.logger.log(Level.INFO, new Object[]{"Adjusting maxLoopIterations to " + adjustedMaxLoopIterations});
            this.setMaxLoopIterations(adjustedMaxLoopIterations);
            return true;
        }
        return false;
    }

    private static class DoublingLoopIterationAdjuster
    implements MaxLoopIterationAdjuster {
        private final LoopBoundPrecisionAdjustment precisionAdjustment;

        public DoublingLoopIterationAdjuster(LoopBoundPrecisionAdjustment pPrecisionAdjustment) {
            this.precisionAdjustment = pPrecisionAdjustment;
        }

        @Override
        public int adjust(int pCurrentValue) {
            return 2 * pCurrentValue;
        }

        @Override
        public boolean canAdjust(int pCurrentValue) {
            return this.precisionAdjustment.maxLoopIterationsUpperBound <= 0 || pCurrentValue * 2 <= this.precisionAdjustment.maxLoopIterationsUpperBound;
        }
    }

    private static class IncrementalLoopIterationAdjuster
    implements MaxLoopIterationAdjuster {
        private final LoopBoundPrecisionAdjustment precisionAdjustment;

        public IncrementalLoopIterationAdjuster(LoopBoundPrecisionAdjustment pPrecisionAdjustment) {
            this.precisionAdjustment = pPrecisionAdjustment;
        }

        @Override
        public int adjust(int pCurrentValue) {
            return ++pCurrentValue;
        }

        @Override
        public boolean canAdjust(int pCurrentValue) {
            return this.precisionAdjustment.maxLoopIterationsUpperBound <= 0 || pCurrentValue < this.precisionAdjustment.maxLoopIterationsUpperBound;
        }
    }

    private static enum StaticLoopIterationAdjuster implements MaxLoopIterationAdjuster
    {
        INSTANCE;


        @Override
        public int adjust(int pCurrentValue) {
            return pCurrentValue;
        }

        @Override
        public boolean canAdjust(int pCurrentValue) {
            return false;
        }
    }

    private static enum MaxLoopIterationAdjusters implements MaxLoopIterationAdjusterFactory
    {
        STATIC{

            @Override
            public MaxLoopIterationAdjuster getMaxLoopIterationAdjuster(LoopBoundPrecisionAdjustment pPrecisionAdjustment) {
                return StaticLoopIterationAdjuster.INSTANCE;
            }
        }
        ,
        INCREMENT{

            @Override
            public MaxLoopIterationAdjuster getMaxLoopIterationAdjuster(LoopBoundPrecisionAdjustment pPrecisionAdjustment) {
                return new IncrementalLoopIterationAdjuster(pPrecisionAdjustment);
            }
        }
        ,
        DOUBLE{

            @Override
            public MaxLoopIterationAdjuster getMaxLoopIterationAdjuster(LoopBoundPrecisionAdjustment pPrecisionAdjustment) {
                return new DoublingLoopIterationAdjuster(pPrecisionAdjustment);
            }
        };

    }

    private static interface MaxLoopIterationAdjusterFactory {
        public MaxLoopIterationAdjuster getMaxLoopIterationAdjuster(LoopBoundPrecisionAdjustment var1);
    }

    private static interface MaxLoopIterationAdjuster {
        public int adjust(int var1);

        public boolean canAdjust(int var1);
    }
}

