/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopbound;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.LoopIterationReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopIterationState;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopStack;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class LoopBoundState
implements AbstractState,
Partitionable,
AvoidanceReportingState,
LoopIterationReportingState {
    private final LoopStack loopStack;
    private final boolean stopIt;
    private int hashCache = 0;

    public LoopBoundState() {
        this(new LoopStack(LoopIterationState.UndeterminedLoopIterationState.newState()), false);
    }

    private LoopBoundState(LoopStack pLoopStack, boolean pStopIt) {
        this.loopStack = Objects.requireNonNull(pLoopStack);
        Preconditions.checkArgument((!pLoopStack.isEmpty() ? 1 : 0) != 0, (Object)"Always initialize the stack with an UndeterminedLoopIterationState");
        Preconditions.checkArgument((pLoopStack.getSize() == 1 && !pLoopStack.peek().isEntryKnown() || pLoopStack.getSize() > 1 && pLoopStack.peek().isEntryKnown() ? 1 : 0) != 0, (Object)"The deepest element in the stack must be an UndeterminedLoopIterationState, and all other elements must be determined.");
        this.stopIt = pStopIt;
    }

    public LoopBoundState exit(LoopStructure.Loop pOldLoop) throws CPATransferException {
        assert (!this.loopStack.isEmpty()) : "Exiting loop without entering the loop. Explicitly use an UndeterminedLoopIterationState if you cannot determine the loop entry.";
        LoopIterationState loopIterationState = this.loopStack.peek();
        if (loopIterationState.isEntryKnown()) {
            if (!pOldLoop.equals(loopIterationState.getLoop())) {
                throw new CPATransferException("Unexpected exit from loop " + pOldLoop + " when loop stack is " + this);
            }
            return new LoopBoundState(this.loopStack.pop(), this.stopIt);
        }
        return this;
    }

    public LoopBoundState enter(LoopStructure.Loop pLoop) {
        return new LoopBoundState(this.loopStack.push(LoopIterationState.DeterminedLoopIterationState.newState(pLoop)), this.stopIt);
    }

    public LoopBoundState visitLoopHead(LoopStructure.Loop pLoop) {
        assert (!this.loopStack.isEmpty()) : "Visiting loop head without entering the loop. Explicitly use an UndeterminedLoopIterationState if you cannot determine the loop entry.";
        if (this.isLoopCounterAbstracted()) {
            return this;
        }
        LoopIterationState loopIterationState = this.loopStack.peek();
        LoopIterationState newLoopIterationState = loopIterationState.visitLoopHead(pLoop);
        if (newLoopIterationState != loopIterationState) {
            return new LoopBoundState(this.loopStack.pop().push(newLoopIterationState), this.stopIt);
        }
        return this;
    }

    public LoopBoundState setStop(boolean pStop) {
        if (this.stopIt == pStop) {
            return this;
        }
        return new LoopBoundState(this.loopStack, pStop);
    }

    public boolean isLoopCounterAbstracted() {
        return this.loopStack.peek().isLoopCounterAbstracted();
    }

    @Override
    public Object getPartitionKey() {
        return this.setStop(false);
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.stopIt;
    }

    @Override
    public String toString() {
        return this.loopStack.peek() + ", stack depth " + this.getDepth() + " [" + Integer.toHexString(System.identityHashCode(this.loopStack.pop())) + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoopBoundState)) {
            return false;
        }
        LoopBoundState other = (LoopBoundState)obj;
        return this.stopIt == other.stopIt && this.loopStack.equals(other.loopStack);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = Objects.hash(this.stopIt, this.loopStack);
        }
        return this.hashCache;
    }

    @Override
    public BooleanFormula getReasonFormula(FormulaManagerView manager) {
        BooleanFormulaManagerView bfmgr = manager.getBooleanFormulaManager();
        BooleanFormula reasonFormula = bfmgr.makeTrue();
        if (this.stopIt) {
            reasonFormula = bfmgr.and(reasonFormula, PreventingHeuristic.LOOPITERATIONS.getFormula(manager, this.getDeepestIteration()));
        }
        return reasonFormula;
    }

    @Override
    public int getIteration(LoopStructure.Loop pLoop) {
        for (LoopIterationState loopIterationState : this.loopStack) {
            if (!loopIterationState.isEntryKnown()) {
                return loopIterationState.getLoopIterationCount(pLoop);
            }
            if (!loopIterationState.getLoop().equals(pLoop)) continue;
            return loopIterationState.getLoopIterationCount(pLoop);
        }
        return 0;
    }

    @Override
    public int getDeepestIteration() {
        int deepestIteration = 0;
        for (LoopIterationState loopIterationState : this.loopStack) {
            deepestIteration = Math.max(deepestIteration, loopIterationState.getMaxIterationCount());
        }
        return deepestIteration;
    }

    @Override
    public Set<LoopStructure.Loop> getDeepestIterationLoops() {
        if (this.loopStack.isEmpty()) {
            return ImmutableSet.of();
        }
        int deepestIteration = this.getDeepestIteration();
        return FluentIterable.from((Iterable)this.loopStack).filter(l -> l.getMaxIterationCount() == deepestIteration).transformAndConcat(l -> l.getDeepestIterationLoops()).toSet();
    }

    public int getDepth() {
        return this.loopStack.getSize() - 1;
    }

    public LoopBoundState enforceAbstraction(int pLoopIterationsBeforeAbstraction) {
        LoopIterationState newLoopIterationState;
        if (this.loopStack.isEmpty()) {
            return this;
        }
        LoopIterationState currentLoopIterationState = this.loopStack.peek();
        if (currentLoopIterationState == (newLoopIterationState = currentLoopIterationState.enforceAbstraction(pLoopIterationsBeforeAbstraction))) {
            return this;
        }
        return new LoopBoundState(this.loopStack.pop().push(newLoopIterationState), this.stopIt);
    }

    public int getMaxNumberOfIterationsInLoopstackFrame() {
        return this.loopStack.peek().getMaxIterationCount();
    }
}

