/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopbound;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundPrecision;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LoopStructure;

@Options(prefix="cpa.loopbound")
public class LoopBoundTransferRelation
extends SingleEdgeTransferRelation {
    private final ImmutableMap<CFAEdge, LoopStructure.Loop> loopEntryEdges;
    private final ImmutableMap<CFAEdge, LoopStructure.Loop> loopExitEdges;
    private final ImmutableListMultimap<CFANode, LoopStructure.Loop> loopHeads;
    @Option(secure=true, description="Only checks for error after loops were unrolled at least this amount of times.")
    private int startAtBound = 0;
    @Option(secure=true, description="Only checks for targets after loops were unrolled exactly a number of times that is contained in this list. The default is an empty list, which means targets are checked in every iteration")
    private List<Integer> checkOnlyAtBounds = ImmutableList.of();

    LoopBoundTransferRelation(Configuration pConfig, CFA pCFA) throws CPAException, InvalidConfigurationException {
        Preconditions.checkNotNull((Object)pCFA, (Object)"CFA instance needed to create LoopBoundCPA");
        pConfig.inject((Object)this);
        if (!pCFA.getLoopStructure().isPresent()) {
            throw new CPAException("LoopBoundCPA cannot work without loop-structure information in CFA.");
        }
        ImmutableMap.Builder entryEdges = ImmutableMap.builder();
        ImmutableMap.Builder exitEdges = ImmutableMap.builder();
        ImmutableListMultimap.Builder heads = ImmutableListMultimap.builder();
        for (LoopStructure.Loop l : pCFA.getLoopStructure().orElseThrow().getAllLoops()) {
            Stream<CFAEdge> incomingEdges = l.getIncomingEdges().stream().filter(e -> l.getLoopHeads().contains((Object)e.getSuccessor())).filter((Predicate<CFAEdge>)Predicates.not((com.google.common.base.Predicate)Predicates.instanceOf(FunctionReturnEdge.class)));
            Stream<CFAEdge> outgoingEdges = l.getOutgoingEdges().stream().filter(Predicates.not((com.google.common.base.Predicate)Predicates.instanceOf(FunctionCallEdge.class)));
            incomingEdges.forEach(e -> entryEdges.put(e, (Object)l));
            outgoingEdges.forEach(e -> exitEdges.put(e, (Object)l));
            l.getLoopHeads().forEach(h -> heads.put(h, (Object)l));
        }
        this.loopEntryEdges = entryEdges.buildOrThrow();
        this.loopExitEdges = exitEdges.buildOrThrow();
        this.loopHeads = heads.build();
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        LoopBoundState state = (LoopBoundState)pState;
        LoopBoundPrecision precision = (LoopBoundPrecision)pPrecision;
        if (pCfaEdge instanceof FunctionCallEdge) {
            return Collections.singleton(pState);
        }
        CFANode loc = pCfaEdge.getSuccessor();
        LoopStructure.Loop oldLoop = (LoopStructure.Loop)this.loopExitEdges.get((Object)pCfaEdge);
        if (oldLoop != null) {
            state = state.exit(oldLoop);
        }
        if (pCfaEdge instanceof FunctionReturnEdge) {
            return Collections.singleton(state);
        }
        LoopStructure.Loop newLoop = null;
        if (precision.shouldTrackStack() && (newLoop = (LoopStructure.Loop)this.loopEntryEdges.get((Object)pCfaEdge)) != null) {
            state = state.enter(newLoop);
        }
        ImmutableList visitedLoops = this.loopHeads.get((Object)loc);
        assert (newLoop == null || visitedLoops.contains(newLoop));
        for (LoopStructure.Loop loop : visitedLoops) {
            state = state.visitLoopHead(loop);
            if (precision.getMaxLoopIterations() > 0 && state.getDeepestIteration() > precision.getMaxLoopIterations()) {
                state = state.setStop(true);
            }
            state = state.enforceAbstraction(precision.getLoopIterationsBeforeAbstraction());
        }
        return Collections.singleton(state);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState state, Iterable<AbstractState> otherStates, @Nullable CFAEdge cfaEdge, Precision precision) throws CPATransferException, InterruptedException {
        int k = ((LoopBoundState)state).getDeepestIteration();
        if ((k < this.startAtBound || !this.checkOnlyAtBounds.isEmpty() && !this.checkOnlyAtBounds.contains(k)) && Iterators.any(otherStates.iterator(), AbstractStates::isTargetState)) {
            return ImmutableList.of();
        }
        return Collections.singleton(state);
    }
}

