/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopbound;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.util.LoopStructure;

interface LoopIterationState {
    public LoopIterationState visitLoopHead(LoopStructure.Loop var1);

    public int getMaxIterationCount();

    public int getLoopIterationCount(LoopStructure.Loop var1);

    public Set<LoopStructure.Loop> getDeepestIterationLoops();

    public boolean isEntryKnown();

    public LoopStructure.Loop getLoop();

    public boolean isLoopCounterAbstracted();

    public LoopIterationState enforceAbstraction(int var1);

    public static class DeterminedLoopIterationState
    implements LoopIterationState {
        private final LoopStructure.Loop loop;
        private final int iteration;
        private final boolean loopCounterAbstracted;

        private DeterminedLoopIterationState(LoopStructure.Loop pLoop) {
            this(pLoop, 0, false);
        }

        private DeterminedLoopIterationState(LoopStructure.Loop pLoop, int pIteration, boolean pLoopCounterAbstracted) {
            this.loop = Objects.requireNonNull(pLoop);
            Preconditions.checkArgument((pIteration >= 0 ? 1 : 0) != 0);
            this.iteration = pIteration;
            this.loopCounterAbstracted = pLoopCounterAbstracted;
        }

        public String toString() {
            return this.loop + " in iteration " + this.getMaxIterationCount();
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof DeterminedLoopIterationState) {
                DeterminedLoopIterationState other = (DeterminedLoopIterationState)pObj;
                return this.loopCounterAbstracted == other.loopCounterAbstracted && this.iteration == other.iteration && this.loop.equals(other.loop);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.loopCounterAbstracted, this.iteration, this.loop);
        }

        @Override
        public LoopIterationState visitLoopHead(LoopStructure.Loop pLoop) {
            if (!this.getLoop().equals(this.loop)) {
                return this;
            }
            return new DeterminedLoopIterationState(this.loop, this.iteration + 1, this.loopCounterAbstracted);
        }

        @Override
        public int getMaxIterationCount() {
            return this.iteration;
        }

        @Override
        public boolean isEntryKnown() {
            return true;
        }

        @Override
        public LoopStructure.Loop getLoop() {
            return this.loop;
        }

        @Override
        public int getLoopIterationCount(LoopStructure.Loop pLoop) {
            return this.loop.equals(pLoop) ? this.iteration : 0;
        }

        @Override
        public Set<LoopStructure.Loop> getDeepestIterationLoops() {
            return Collections.singleton(this.loop);
        }

        public static LoopIterationState newState(LoopStructure.Loop pLoop) {
            return new DeterminedLoopIterationState(pLoop);
        }

        @Override
        public boolean isLoopCounterAbstracted() {
            return this.loopCounterAbstracted;
        }

        @Override
        public LoopIterationState enforceAbstraction(int pLoopIterationsBeforeAbstraction) {
            if (this.getMaxIterationCount() <= pLoopIterationsBeforeAbstraction) {
                return this;
            }
            return new DeterminedLoopIterationState(this.loop, pLoopIterationsBeforeAbstraction, true);
        }
    }

    public static class UndeterminedLoopIterationState
    implements LoopIterationState {
        private final PersistentSortedMap<LoopStructure.Loop, LoopIteration> iterations;
        private final int maxLoopIteration;
        private final boolean loopCounterAbstracted;

        private UndeterminedLoopIterationState() {
            this((PersistentSortedMap<LoopStructure.Loop, LoopIteration>)PathCopyingPersistentTreeMap.of(), 0, false);
        }

        private UndeterminedLoopIterationState(PersistentSortedMap<LoopStructure.Loop, LoopIteration> pIterations, int pMaxLoopIteration, boolean pLoopCounterAbstracted) {
            this.iterations = Objects.requireNonNull(pIterations);
            Preconditions.checkArgument((pMaxLoopIteration >= 0 ? 1 : 0) != 0);
            this.maxLoopIteration = pMaxLoopIteration;
            this.loopCounterAbstracted = pLoopCounterAbstracted;
        }

        @Override
        public LoopIterationState visitLoopHead(LoopStructure.Loop pLoop) {
            LoopStructure.Loop loop = pLoop;
            LoopIteration storedIteration = (LoopIteration)this.iterations.getOrDefault((Object)loop, (Object)new LoopIteration(pLoop, 0));
            if (loop.equals(storedIteration.getLoop())) {
                storedIteration = storedIteration.increment();
                return new UndeterminedLoopIterationState((PersistentSortedMap<LoopStructure.Loop, LoopIteration>)this.iterations.putAndCopy((Object)loop, (Object)storedIteration), Math.max(storedIteration.getCount(), this.maxLoopIteration), this.loopCounterAbstracted);
            }
            return this;
        }

        @Override
        public int getMaxIterationCount() {
            return this.maxLoopIteration;
        }

        public String toString() {
            return String.format("Undetermined loop iteration state; at least %d iterations in some loop (%s).", this.maxLoopIteration, this.iterations);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof UndeterminedLoopIterationState) {
                UndeterminedLoopIterationState other = (UndeterminedLoopIterationState)pObj;
                return this.loopCounterAbstracted == other.loopCounterAbstracted && this.maxLoopIteration == other.maxLoopIteration && this.iterations.equals(other.iterations);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.loopCounterAbstracted, this.maxLoopIteration, this.iterations);
        }

        @Override
        public boolean isEntryKnown() {
            return false;
        }

        @Override
        public LoopStructure.Loop getLoop() {
            throw new IllegalStateException("Loop is unknown.");
        }

        @Override
        public int getLoopIterationCount(LoopStructure.Loop pLoop) {
            LoopIteration iteration = (LoopIteration)this.iterations.get((Object)pLoop);
            if (iteration == null) {
                return 0;
            }
            return iteration.getCount();
        }

        @Override
        public Set<LoopStructure.Loop> getDeepestIterationLoops() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Map.Entry entry : this.iterations.entrySet()) {
                int count = ((LoopIteration)entry.getValue()).getCount();
                assert (count <= this.maxLoopIteration);
                if (count != this.maxLoopIteration) continue;
                builder.add((Object)((LoopStructure.Loop)entry.getKey()));
            }
            return builder.build();
        }

        @Override
        public boolean isLoopCounterAbstracted() {
            return this.loopCounterAbstracted;
        }

        @Override
        public LoopIterationState enforceAbstraction(int pLoopIterationsBeforeAbstraction) {
            if (this.getMaxIterationCount() <= pLoopIterationsBeforeAbstraction) {
                return this;
            }
            PersistentSortedMap iters = this.iterations;
            for (Map.Entry entry : iters.entrySet()) {
                LoopStructure.Loop loop = (LoopStructure.Loop)entry.getKey();
                LoopIteration oldIterationCount = (LoopIteration)entry.getValue();
                if (oldIterationCount.getCount() <= pLoopIterationsBeforeAbstraction) continue;
                iters = iters.putAndCopy((Object)loop, (Object)new LoopIteration(oldIterationCount.getLoop(), pLoopIterationsBeforeAbstraction));
            }
            return new UndeterminedLoopIterationState(iters, pLoopIterationsBeforeAbstraction, true);
        }

        public static LoopIterationState newState() {
            return new UndeterminedLoopIterationState();
        }

        private static class LoopIteration {
            private final LoopStructure.Loop loop;
            private final int iteration;

            public LoopIteration(LoopStructure.Loop pLoop, int pIteration) {
                this.loop = Objects.requireNonNull(pLoop);
                Preconditions.checkArgument((pIteration >= 0 ? 1 : 0) != 0);
                this.iteration = pIteration;
            }

            public LoopStructure.Loop getLoop() {
                return this.loop;
            }

            public int getCount() {
                return this.iteration;
            }

            public LoopIteration increment() {
                return new LoopIteration(this.loop, this.getCount() + 1);
            }

            public String toString() {
                return String.format("%d through %s", this.iteration, this.loop);
            }

            public int hashCode() {
                return Objects.hash(this.iteration, this.loop);
            }

            public boolean equals(Object pObj) {
                if (this == pObj) {
                    return true;
                }
                if (pObj instanceof LoopIteration) {
                    LoopIteration other = (LoopIteration)pObj;
                    return this.iteration == other.iteration && this.loop.equals(other.loop);
                }
                return false;
            }
        }
    }
}

