/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopbound;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopIterationState;

final class LoopStack
implements Iterable<LoopIterationState> {
    private static final LoopStack EMPTY_STACK = new LoopStack();
    private final LoopIterationState head;
    private final LoopStack tail;
    private final int size;
    private int hashCache = 0;

    private LoopStack() {
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    LoopStack(LoopIterationState pLoop) {
        this.head = Objects.requireNonNull(pLoop);
        this.tail = EMPTY_STACK;
        this.size = 1;
    }

    private LoopStack(LoopIterationState pHead, LoopStack pTail) {
        this.head = Objects.requireNonNull(pHead);
        this.tail = pTail;
        this.size = pTail.size + 1;
    }

    public LoopIterationState peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Stack is empty.");
        }
        return this.head;
    }

    public LoopStack pop() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"Stack is empty.");
        return this.tail;
    }

    public LoopStack push(LoopIterationState pHead) {
        return new LoopStack(pHead, this);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        if (this.tail.isEmpty()) {
            return this.head.toString();
        }
        return String.format("%s (%s)", this.head, this.tail);
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof LoopStack) {
            LoopStack other = (LoopStack)pObj;
            if (this.hashCode() != other.hashCode()) {
                return false;
            }
            return this.size == other.size && Objects.equals(this.head, other.head) && Objects.equals(this.tail, other.tail);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = Objects.hash(this.head, this.tail);
        }
        return this.hashCache;
    }

    @Override
    public Iterator<LoopIterationState> iterator() {
        return new Iterator<LoopIterationState>(){
            private LoopStack current;
            {
                this.current = LoopStack.this;
            }

            @Override
            public boolean hasNext() {
                return !this.current.isEmpty();
            }

            @Override
            public LoopIterationState next() {
                LoopIterationState next = this.current.peek();
                this.current = this.current.pop();
                return next;
            }
        };
    }
}

