/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modifications;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.modifications.ModificationsState;
import org.sosy_lab.cpachecker.cpa.modifications.ModificationsTransferRelation;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFATraversal;

@Options(prefix="differential")
public class ModificationsCPA
implements ConfigurableProgramAnalysis {
    @Option(secure=true, description="Program to check against", name="program", required=true)
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path originalProgram = null;
    @Option(secure=true, description="ignore declarations when detecting modifications, be careful when variables are renamed (could be unsound)")
    private boolean ignoreDeclarations = false;
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfaForComparison;
    private final TransferRelation transfer;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ModificationsCPA.class);
    }

    @SuppressFBWarnings(value={"NP"})
    public ModificationsCPA(CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        CFACreator cfaCreator = new CFACreator(this.config, this.logger, this.shutdownNotifier);
        try {
            this.cfaForComparison = cfaCreator.parseFileAndCreateCFA((List<String>)ImmutableList.of((Object)this.originalProgram.toString()));
            if (this.ignoreDeclarations) {
                CFATraversal.DeclarationCollectingCFAVisitor varDeclCollect = new CFATraversal.DeclarationCollectingCFAVisitor();
                CFATraversal.dfs().traverse(this.cfaForComparison.getMainFunction(), varDeclCollect);
                Map<String, Set<String>> origFunToDeclNames = varDeclCollect.getVisitedDeclarations();
                varDeclCollect = new CFATraversal.DeclarationCollectingCFAVisitor();
                CFATraversal.dfs().traverse(pCfa.getMainFunction(), varDeclCollect);
                this.transfer = new ModificationsTransferRelation(true, origFunToDeclNames, varDeclCollect.getVisitedDeclarations());
            } else {
                this.transfer = new ModificationsTransferRelation();
            }
        }
        catch (ParserException pE) {
            throw new InvalidConfigurationException("Parser error for originalProgram", (Throwable)pE);
        }
        catch (IOException | InterruptedException pE) {
            throw new AssertionError((Object)pE);
        }
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return new FlatLatticeDomain();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.getAbstractDomain());
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return new ModificationsState(node, this.cfaForComparison.getMainFunction());
    }
}

