/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modifications;

import com.google.common.collect.FluentIterable;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.cpa.modifications.ModificationsCPA;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public final class ModificationsState
implements AvoidanceReportingState,
AbstractQueryableState,
Graphable {
    private boolean hasModification;
    private CFANode locationInGivenCfa;
    private CFANode locationInOriginalCfa;

    public ModificationsState(CFANode pLocationInGivenCfa, CFANode pLocationInOriginalCfa) {
        this(pLocationInGivenCfa, pLocationInOriginalCfa, false);
    }

    public ModificationsState(CFANode pLocationInGivenCfa, CFANode pLocationInOriginalCfa, boolean pHasModification) {
        this.locationInGivenCfa = pLocationInGivenCfa;
        this.locationInOriginalCfa = pLocationInOriginalCfa;
        this.hasModification = pHasModification;
    }

    public CFANode getLocationInOriginalCfa() {
        return this.locationInOriginalCfa;
    }

    public CFANode getLocationInGivenCfa() {
        return this.locationInGivenCfa;
    }

    public boolean hasModification() {
        return this.hasModification;
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        ModificationsState that = (ModificationsState)pO;
        return Objects.equals(this.locationInOriginalCfa, that.locationInOriginalCfa) && Objects.equals(this.locationInGivenCfa, that.locationInGivenCfa) && this.hasModification == that.hasModification;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.locationInOriginalCfa, this.locationInGivenCfa, this.hasModification);
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.hasModification;
    }

    @Override
    public BooleanFormula getReasonFormula(FormulaManagerView pMgr) {
        if (this.mustDumpAssumptionForAvoidance()) {
            return pMgr.getBooleanFormulaManager().makeFalse();
        }
        return pMgr.getBooleanFormulaManager().makeTrue();
    }

    @Override
    public String getCPAName() {
        return ModificationsCPA.class.getSimpleName();
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "is_modified": {
                return this.hasModification;
            }
        }
        throw new InvalidQueryException("Unknown query to " + this.getClass().getSimpleName() + ": " + pProperty);
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.hasModification) {
            sb.append("Misfit: ");
            FluentIterable<CFAEdge> edgesInOrig = CFAUtils.enteringEdges(this.locationInOriginalCfa);
            sb.append("{");
            for (CFAEdge e : edgesInOrig) {
                sb.append(e);
                sb.append(", ");
            }
            sb.append("}");
        } else {
            sb.append("No modification");
        }
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return this.hasModification;
    }
}

