/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modifications;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.modifications.ModificationsState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class ModificationsTransferRelation
extends SingleEdgeTransferRelation {
    private final boolean ignoreDeclarations;
    private final Map<String, Set<String>> funToVarsOrig;
    private final Map<String, Set<String>> funToVarsGiven;

    public ModificationsTransferRelation(boolean pIgnoreDeclarations, Map<String, Set<String>> pFunToVarsOrig, Map<String, Set<String>> pFunToVarsGiven) {
        this.ignoreDeclarations = pIgnoreDeclarations;
        this.funToVarsOrig = pFunToVarsOrig;
        this.funToVarsGiven = pFunToVarsGiven;
    }

    public ModificationsTransferRelation() {
        this(false, (Map<String, Set<String>>)ImmutableMap.of(), (Map<String, Set<String>>)ImmutableMap.of());
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        ModificationsState locations = (ModificationsState)pState;
        if (!locations.hasModification()) {
            CFANode nodeInGiven = locations.getLocationInGivenCfa();
            CFANode nodeInOriginal = locations.getLocationInOriginalCfa();
            if (CFAUtils.leavingEdges(nodeInGiven).contains((Object)pCfaEdge)) {
                CFANode succInGiven = pCfaEdge.getSuccessor();
                HashSet<ModificationsState> successors = new HashSet<ModificationsState>();
                for (CFAEdge edgeInOriginal : CFAUtils.leavingEdges(nodeInOriginal)) {
                    Optional<ModificationsState> potSucc = this.findMatchingSuccessor(pCfaEdge, edgeInOriginal);
                    if (!potSucc.isPresent()) continue;
                    successors.add(potSucc.orElseThrow());
                    break;
                }
                if (successors.isEmpty()) {
                    for (CFAEdge edgeInOriginal : CFAUtils.leavingEdges(nodeInOriginal)) {
                        successors.add(new ModificationsState(succInGiven, edgeInOriginal.getSuccessor(), true));
                    }
                }
                assert (!successors.isEmpty()) : "List of successors should never be empty if previous state represents no modification";
                return successors;
            }
        }
        return ImmutableSet.of();
    }

    private Optional<ModificationsState> findMatchingSuccessor(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal) {
        boolean stuttered;
        CFAEdge originalEdge = pEdgeInOriginal;
        do {
            stuttered = false;
            if (this.edgesMatch(pEdgeInGiven, originalEdge)) {
                return Optional.of(new ModificationsState(pEdgeInGiven.getSuccessor(), originalEdge.getSuccessor()));
            }
            if (!this.ignoreDeclarations) continue;
            if (pEdgeInGiven instanceof CDeclarationEdge && !this.declarationNameAlreadyExistsInOtherCFA(true, (CDeclarationEdge)pEdgeInGiven)) {
                return Optional.of(new ModificationsState(pEdgeInGiven.getSuccessor(), originalEdge.getPredecessor()));
            }
            if (!(originalEdge instanceof CDeclarationEdge) || this.declarationNameAlreadyExistsInOtherCFA(false, (CDeclarationEdge)originalEdge) || originalEdge.getSuccessor().getNumLeavingEdges() != 1) continue;
            originalEdge = originalEdge.getSuccessor().getLeavingEdge(0);
            stuttered = true;
        } while (stuttered);
        return Optional.empty();
    }

    private boolean declarationNameAlreadyExistsInOtherCFA(boolean isOtherOrigCFA, CDeclarationEdge pDeclEdge) {
        if (!pDeclEdge.getDeclaration().isGlobal() && this.containsDeclaration(isOtherOrigCFA ? this.funToVarsOrig.get(pDeclEdge.getSuccessor().getFunctionName()) : this.funToVarsGiven.get(pDeclEdge.getSuccessor().getFunctionName()), pDeclEdge.getDeclaration().getOrigName())) {
            return true;
        }
        return this.containsDeclaration(isOtherOrigCFA ? this.funToVarsOrig.get("") : this.funToVarsGiven.get(""), pDeclEdge.getDeclaration().getOrigName());
    }

    private boolean containsDeclaration(@Nullable Set<String> varNames, String varName) {
        return varNames != null && varNames.contains(varName);
    }

    private boolean edgesMatch(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal) {
        String sndAst;
        String firstAst = pEdgeInGiven.getRawStatement();
        return firstAst.equals(sndAst = pEdgeInOriginal.getRawStatement()) && pEdgeInGiven.getEdgeType() == pEdgeInOriginal.getEdgeType() && this.successorsMatch(pEdgeInGiven, pEdgeInOriginal);
    }

    private boolean successorsMatch(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal) {
        CFANode givenSuccessor = pEdgeInGiven.getSuccessor();
        CFANode originalSuccessor = pEdgeInOriginal.getSuccessor();
        if (pEdgeInGiven.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
            block0: for (CFAEdge enterBeforeCall : CFAUtils.enteringEdges(((FunctionReturnEdge)pEdgeInGiven).getSummaryEdge().getPredecessor())) {
                for (CFAEdge enterOriginalBeforeCAll : CFAUtils.enteringEdges(((FunctionReturnEdge)pEdgeInOriginal).getSummaryEdge().getPredecessor())) {
                    if (!this.edgesMatch(enterBeforeCall, enterOriginalBeforeCAll)) continue;
                    continue block0;
                }
                return false;
            }
        }
        return givenSuccessor.getClass() == originalSuccessor.getClass() && givenSuccessor.getFunctionName().equals(originalSuccessor.getFunctionName());
    }
}

