/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modificationsprop;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.modificationsprop.ModificationsPropHelper;
import org.sosy_lab.cpachecker.cpa.modificationsprop.ModificationsPropMergeOperator;
import org.sosy_lab.cpachecker.cpa.modificationsprop.ModificationsPropState;
import org.sosy_lab.cpachecker.cpa.modificationsprop.ModificationsPropTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;

@Options(prefix="differential")
public class ModificationsPropCPA
implements ConfigurableProgramAnalysis,
AutoCloseable {
    @Option(secure=true, description="Program to check against", name="program", required=true)
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path originalProgram = null;
    @Option(secure=true, description="ignore declarations when detecting modifications, be careful when variables are renamed (could be unsound)")
    private boolean ignoreDeclarations = false;
    @Option(secure=true, description="perform assumption implication check")
    private boolean implicationCheck = true;
    @Option(secure=true, description="perform preprocessing to detect states from which error locations are reachable")
    private boolean performPreprocessing = false;
    @Option(secure=true, description="safely stop analysis on pointer accesses and similar")
    private boolean stopOnPointers = false;
    @Option(secure=true, description="Switch on/off to form the union of variable sets at identical location pairs. Set cpa.automaton.deleteDoubleEdges as well!")
    private boolean variableSetMerge = false;
    @Option(secure=true, name="badstateProperties", description="comma-separated list of files with property specifications that should be considered when determining the nodes that are in the reachability property.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<Path> relevantProperties = ImmutableList.of();
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfaOrig;
    private final TransferRelation transfer;
    private final DelegateAbstractDomain<ModificationsPropState> domain;
    private final Solver solver;
    private final ModificationsPropHelper helper;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ModificationsPropCPA.class);
    }

    @SuppressFBWarnings(value={"NP"})
    public ModificationsPropCPA(CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.domain = DelegateAbstractDomain.getInstance();
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.solver = Solver.create(pConfig, pLogger, pShutdownNotifier);
        CFACreator cfaCreator = new CFACreator(this.config, this.logger, this.shutdownNotifier);
        try {
            this.cfaOrig = cfaCreator.parseFileAndCreateCFA((List<String>)ImmutableList.of((Object)this.originalProgram.toString()));
            ImmutableSet<CFANode> errorLocsOrig = this.findErrorLocations(this.cfaOrig);
            ImmutableSet<CFANode> errorLocsMod = this.findErrorLocations(pCfa);
            ImmutableSet errorLocsOrig_reachable = this.performPreprocessing ? this.computeElementsWithPathTo((Set)errorLocsOrig, (Function)CFAUtils::allPredecessorsOf) : ImmutableSet.copyOf(this.cfaOrig.getAllNodes());
            Object errorLocsMod_new_reachable = this.performPreprocessing ? this.computeElementsWithPathTo((Set)errorLocsMod, (Function)CFAUtils::allPredecessorsOf) : ImmutableSet.copyOf(pCfa.getAllNodes());
            this.helper = new ModificationsPropHelper((ImmutableSet<CFANode>)new ImmutableSet.Builder().addAll(errorLocsMod).addAll(errorLocsOrig).build(), this.ignoreDeclarations, this.implicationCheck, this.stopOnPointers, (Set<CFANode>)errorLocsOrig_reachable, (Set<CFANode>)errorLocsMod_new_reachable, this.solver, this.initializeCToFormulaConverter(this.solver.getFormulaManager(), pLogger, pConfig, pShutdownNotifier, pCfa.getMachineModel()), this.logger);
            this.transfer = new ModificationsPropTransferRelation(this.helper);
        }
        catch (ParserException pE) {
            throw new InvalidConfigurationException("Parser error for original program.", (Throwable)pE);
        }
        catch (IOException | InterruptedException pE) {
            throw new AssertionError((Object)pE);
        }
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.variableSetMerge ? new ModificationsPropMergeOperator() : new MergeSepOperator();
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.getAbstractDomain());
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return new ModificationsPropState(node, (CFANode)this.cfaOrig.getMainFunction(), (ImmutableSet<String>)ImmutableSet.of(), new ArrayDeque<CFANode>(), this.helper);
    }

    @Override
    public void close() {
        this.solver.close();
    }

    private CtoFormulaConverter initializeCToFormulaConverter(FormulaManagerView pFormulaManager, LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier, MachineModel pMachineModel) throws InvalidConfigurationException {
        FormulaEncodingWithPointerAliasingOptions options = new FormulaEncodingWithPointerAliasingOptions(pConfig);
        TypeHandlerWithPointerAliasing typeHandler = new TypeHandlerWithPointerAliasing(this.logger, pMachineModel, options);
        return new CToFormulaConverterWithPointerAliasing(options, pFormulaManager, pMachineModel, Optional.empty(), pLogger, pShutdownNotifier, typeHandler, AnalysisDirection.FORWARD);
    }

    private ImmutableSet<CFANode> findErrorLocations(CFA cfa) {
        if (!this.relevantProperties.isEmpty()) {
            try {
                Configuration reachPropConfig = Configuration.builder().setOption("cpa", "cpa.arg.ARGCPA").setOption("ARGCPA.cpa", "cpa.composite.CompositeCPA").setOption("CompositeCPA.cpas", "cpa.location.LocationCPA").setOption("cpa.composite.aggregateBasicBlocks", "false").setOption("cpa.automaton.breakOnTargetState", "-1").setOption("output.disable", "true").setOption("analysis.entryFunction", cfa.getMainFunction().getFunctionName()).build();
                ReachedSetFactory rsFactory = new ReachedSetFactory(reachPropConfig, this.logger);
                ConfigurableProgramAnalysis cpa = new CPABuilder(reachPropConfig, this.logger, this.shutdownNotifier, rsFactory).buildCPAs(cfa, Specification.fromFiles(this.relevantProperties, cfa, reachPropConfig, this.logger, this.shutdownNotifier), AggregatedReachedSets.empty());
                ReachedSet reached = rsFactory.createAndInitialize(cpa, cfa.getMainFunction(), StateSpacePartition.getDefaultPartition());
                CPAAlgorithm.create(cpa, this.logger, reachPropConfig, this.shutdownNotifier).run(reached);
                Preconditions.checkState((!reached.hasWaitingState() ? 1 : 0) != 0);
                ImmutableList errorStates = FluentIterable.from((Iterable)reached.asCollection()).filter(state -> ((ARGState)state).isTarget()).transform(state -> (ARGState)state).toList();
                return Collections3.transformedImmutableSetCopy((Collection)errorStates, errorState -> AbstractStates.extractLocation(errorState));
            }
            catch (InterruptedException | InvalidConfigurationException | CPAException e) {
                this.logger.logException(Level.SEVERE, e, "Failed to determine relevant edges");
            }
        }
        return ImmutableSet.of();
    }

    private <Element> Set<Element> computeElementsWithPathTo(Set<Element> initialElements, Function<Element, Iterable<Element>> predecessors) {
        ArrayDeque<Element> waitlist = new ArrayDeque<Element>(initialElements);
        HashSet<Element> explored = new HashSet<Element>(initialElements);
        while (!waitlist.isEmpty()) {
            Object el = waitlist.poll();
            for (Element pred : predecessors.apply(el)) {
                if (!explored.add(pred)) continue;
                waitlist.add(pred);
            }
        }
        return new ImmutableSet.Builder().addAll(explored).build();
    }
}

