/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modificationsprop;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.MoreStrings;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cpa.modificationsprop.PointerAccessException;
import org.sosy_lab.cpachecker.cpa.modificationsprop.VariableIdentifierVisitor;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAEdgeUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class ModificationsPropHelper {
    private final ImmutableSet<CFANode> errorLocationsInOrigOrMod;
    private final boolean ignoreDeclarations;
    private final boolean implicationCheck;
    private final Set<CFANode> mayReachErrorLocOrig;
    private final Set<CFANode> mayReachErrorLocMod;
    private final Solver solver;
    private final CtoFormulaConverter converter;
    private final LogManager logger;
    private final VariableIdentifierVisitor visitor;

    public ModificationsPropHelper(ImmutableSet<CFANode> pErrorLocations, boolean pIgnoreDeclarations, boolean pImplicationCheck, boolean pStopOnPointers, Set<CFANode> pReachElocOrig, Set<CFANode> pReachElocMod, Solver pSolver, CtoFormulaConverter pConverter, LogManager pLogger) {
        this.errorLocationsInOrigOrMod = pErrorLocations;
        this.ignoreDeclarations = pIgnoreDeclarations;
        this.implicationCheck = pImplicationCheck;
        this.mayReachErrorLocOrig = pReachElocOrig;
        this.mayReachErrorLocMod = pReachElocMod;
        this.solver = pSolver;
        this.converter = pConverter;
        this.logger = pLogger;
        this.visitor = new VariableIdentifierVisitor(pStopOnPointers);
    }

    boolean edgesMatchIgnoringFunctionReturnLocation(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal) {
        String sndAst;
        String firstAst = pEdgeInGiven.getRawStatement();
        return firstAst.equals(sndAst = pEdgeInOriginal.getRawStatement()) && pEdgeInGiven.getEdgeType() == pEdgeInOriginal.getEdgeType() && this.inSameFunction(pEdgeInGiven.getSuccessor(), pEdgeInOriginal.getSuccessor());
    }

    boolean isUntracked(CFAEdge pEdge) {
        return pEdge instanceof BlankEdge || this.ignoreDeclarations && pEdge instanceof CDeclarationEdge;
    }

    CFANode skipUntrackedOperations(CFANode pNode) {
        CFAEdge currentEdge;
        CFANode currentNode = pNode;
        while (currentNode.getNumLeavingEdges() == 1 && !this.isErrorLocation(currentNode) && this.isUntracked(currentEdge = currentNode.getLeavingEdge(0)) && this.inSameFunction(currentNode, currentEdge.getSuccessor())) {
            currentNode = currentEdge.getSuccessor();
            if (currentNode != pNode) continue;
            this.logProblem("Found infinite sequence of untracked operations.");
            return pNode;
        }
        return currentNode;
    }

    Pair<CFANode, ImmutableSet<String>> skipAssignment(CFANode pNode, ImmutableSet<String> pVars) {
        if (pNode.getNumLeavingEdges() == 1 && !this.isErrorLocation(pNode)) {
            String written;
            CFAEdge edge = pNode.getLeavingEdge(0);
            if (edge instanceof CStatementEdge) {
                CStatement stmt = ((CStatementEdge)edge).getStatement();
                if (stmt instanceof CExpressionStatement) {
                    return Pair.of(edge.getSuccessor(), pVars);
                }
                if (stmt instanceof CExpressionAssignmentStatement) {
                    try {
                        Set<String> assigned = ((CExpressionAssignmentStatement)stmt).getLeftHandSide().accept(this.visitor);
                        if (pVars.containsAll(assigned)) {
                            return Pair.of(edge.getSuccessor(), pVars);
                        }
                        return Pair.of(edge.getSuccessor(), new ImmutableSet.Builder().addAll(pVars).addAll(assigned).build());
                    }
                    catch (PointerAccessException assigned) {}
                } else if (stmt instanceof CFunctionCallAssignmentStatement) {
                    try {
                        Set<String> assigned = ((CFunctionCallAssignmentStatement)stmt).getLeftHandSide().accept(this.visitor);
                        CFunctionCallExpression funCall = ((CFunctionCall)stmt).getFunctionCallExpression();
                        assigned.addAll((Collection<String>)funCall.getFunctionNameExpression().accept(this.visitor));
                        for (CExpression exp : funCall.getParameterExpressions()) {
                            if (CTypes.isArithmeticType(exp.getExpressionType())) {
                                exp.accept(this.visitor);
                                continue;
                            }
                            assigned.addAll((Collection<String>)exp.accept(this.visitor));
                        }
                        if (pVars.containsAll(assigned)) {
                            return Pair.of(edge.getSuccessor(), pVars);
                        }
                        return Pair.of(edge.getSuccessor(), new ImmutableSet.Builder().addAll(pVars).addAll(assigned).build());
                    }
                    catch (PointerAccessException assigned) {}
                } else if (stmt instanceof CFunctionCallStatement) {
                    try {
                        CFunctionCallExpression funCall = ((CFunctionCall)stmt).getFunctionCallExpression();
                        Set<String> assigned = funCall.getFunctionNameExpression().accept(this.visitor);
                        for (CExpression exp : funCall.getParameterExpressions()) {
                            if (CTypes.isArithmeticType(exp.getExpressionType())) {
                                exp.accept(this.visitor);
                                continue;
                            }
                            assigned.addAll((Collection<String>)exp.accept(this.visitor));
                        }
                        if (pVars.containsAll(assigned)) {
                            return Pair.of(edge.getSuccessor(), pVars);
                        }
                        return Pair.of(edge.getSuccessor(), new ImmutableSet.Builder().addAll(pVars).addAll(assigned).build());
                    }
                    catch (PointerAccessException pointerAccessException) {}
                }
            } else if (edge instanceof CDeclarationEdge && (written = CFAEdgeUtils.getLeftHandVariable(edge)) != null) {
                if (pVars.contains((Object)written)) {
                    return Pair.of(edge.getSuccessor(), pVars);
                }
                return Pair.of(edge.getSuccessor(), new ImmutableSet.Builder().addAll(pVars).add((Object)written).build());
            }
        }
        return Pair.of(pNode, pVars);
    }

    ImmutableSet<String> modifySetForAssignment(CStatementEdge pEdge, ImmutableSet<String> pVars) throws PointerAccessException {
        ImmutableSet vars = pVars;
        String lhs = CFAEdgeUtils.getLeftHandVariable(pEdge);
        if (lhs != null && vars.contains((Object)lhs)) {
            vars = FluentIterable.from(pVars).filter(Predicates.not((Predicate)Predicates.equalTo((Object)lhs))).toSet();
        }
        Set<Object> maybeAssigned = null;
        Set<Object> rhs = new HashSet();
        CStatement stmt = pEdge.getStatement();
        if (stmt instanceof CExpressionStatement) {
            rhs = ((CExpressionStatement)stmt).getExpression().accept(this.visitor);
        } else if (stmt instanceof CFunctionCallStatement) {
            CFunctionCallExpression funCall = ((CFunctionCall)stmt).getFunctionCallExpression();
            rhs.addAll((Collection)funCall.getFunctionNameExpression().accept(this.visitor));
            for (CExpression exp : funCall.getParameterExpressions()) {
                if (CTypes.isArithmeticType(exp.getExpressionType())) {
                    exp.accept(this.visitor);
                    continue;
                }
                rhs.addAll((Collection<Object>)exp.accept(this.visitor));
            }
            maybeAssigned = rhs;
        } else if (stmt instanceof CAssignment) {
            maybeAssigned = ((CAssignment)stmt).getLeftHandSide().accept(this.visitor);
            if (stmt instanceof CExpressionAssignmentStatement) {
                rhs.addAll((Collection<Object>)((CExpressionAssignmentStatement)stmt).getRightHandSide().accept(this.visitor));
            } else {
                CFunctionCallExpression funCall = ((CFunctionCall)stmt).getFunctionCallExpression();
                rhs.addAll((Collection<Object>)funCall.getFunctionNameExpression().accept(this.visitor));
                for (CExpression exp : funCall.getParameterExpressions()) {
                    rhs.addAll((Collection<Object>)exp.accept(this.visitor));
                }
                maybeAssigned.addAll(rhs);
            }
        }
        if (maybeAssigned != null && !Collections.disjoint(vars, rhs)) {
            return new ImmutableSet.Builder().addAll((Iterable)vars).addAll(maybeAssigned).build();
        }
        return vars;
    }

    boolean areVariablesUsedInEdge(CFAEdge pEdge, ImmutableSet<String> pVars) {
        Set<Object> usedVars;
        block12: {
            usedVars = new HashSet();
            if (pEdge instanceof BlankEdge || pEdge instanceof CFunctionReturnEdge || pEdge instanceof CFunctionSummaryEdge) {
                return false;
            }
            if (pEdge instanceof CStatementEdge) {
                return false;
            }
            try {
                if (pEdge instanceof CDeclarationEdge) {
                    CDeclaration decl = ((CDeclarationEdge)pEdge).getDeclaration();
                    if (decl instanceof CFunctionDeclaration || decl instanceof CTypeDeclaration) {
                        return false;
                    }
                    if (!(decl instanceof CVariableDeclaration)) break block12;
                    CInitializer initl = ((CVariableDeclaration)decl).getInitializer();
                    if (initl instanceof CInitializerExpression) {
                        usedVars = ((CInitializerExpression)initl).getExpression().accept(this.visitor);
                        break block12;
                    }
                    return !pVars.isEmpty();
                }
                if (pEdge instanceof CReturnStatementEdge) {
                    CExpression exp = ((CReturnStatementEdge)pEdge).getExpression().orElse(null);
                    if (exp != null) {
                        usedVars = exp.accept(this.visitor);
                        break block12;
                    }
                    return !pVars.isEmpty();
                }
                if (pEdge instanceof CAssumeEdge) {
                    usedVars = ((CAssumeEdge)pEdge).getExpression().accept(this.visitor);
                    break block12;
                }
                if (pEdge instanceof CFunctionCallEdge) {
                    for (CExpression exp : ((CFunctionCallEdge)pEdge).getArguments()) {
                        usedVars.addAll(exp.accept(this.visitor));
                    }
                    break block12;
                }
                return !pVars.isEmpty();
            }
            catch (PointerAccessException e) {
                return true;
            }
        }
        return !Collections.disjoint(usedVars, pVars);
    }

    boolean useImplicationCheck() {
        return this.implicationCheck;
    }

    boolean implies(CAssumeEdge pAntecedent, CAssumeEdge pConsequence) {
        BooleanFormula fConsequence;
        BooleanFormula fAntecedent;
        SSAMap.SSAMapBuilder ssaMap = SSAMap.emptySSAMap().builder();
        this.logger.log(Level.FINEST, new Object[]{"Checking whether", MoreStrings.lazyString(() -> pAntecedent.getCode()), "implies", MoreStrings.lazyString(() -> pConsequence.getCode()), "."});
        try {
            fAntecedent = this.converter.makePredicate(pAntecedent.getExpression(), pAntecedent, pAntecedent.getPredecessor().getFunctionName(), ssaMap, pAntecedent.getTruthAssumption());
            fConsequence = this.converter.makePredicate(pConsequence.getExpression(), pConsequence, pConsequence.getPredecessor().getFunctionName(), ssaMap, pConsequence.getTruthAssumption());
        }
        catch (AssertionError | IllegalArgumentException | InterruptedException | UnrecognizedCodeException e) {
            this.logger.log(Level.WARNING, new Object[]{"Converting to predicate failed."});
            return false;
        }
        try {
            return this.solver.implies(fAntecedent, fConsequence);
        }
        catch (InterruptedException | SolverException e) {
            this.logger.log(Level.WARNING, new Object[]{"Implication check failed."});
            return false;
        }
    }

    boolean isErrorLocation(CFANode node) {
        return this.errorLocationsInOrigOrMod.contains((Object)node);
    }

    boolean inSameFunction(CFANode pNodeInGiven, CFANode pNodeInOriginal) {
        return pNodeInGiven.getFunctionName().equals(pNodeInOriginal.getFunctionName());
    }

    boolean mayReachErrorLocation(CFANode pNode, boolean pOriginal) {
        if (pOriginal) {
            return this.mayReachErrorLocOrig.contains(pNode);
        }
        return this.mayReachErrorLocMod.contains(pNode);
    }

    VariableIdentifierVisitor getVisitor() {
        return this.visitor;
    }

    void logCase(String pMsg) {
        this.logger.log(Level.FINEST, new Object[]{pMsg});
    }

    void logProblem(String pMsg) {
        this.logger.log(Level.WARNING, new Object[]{pMsg});
    }
}

