/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modificationsprop;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.cpa.modificationsprop.ModificationsPropCPA;
import org.sosy_lab.cpachecker.cpa.modificationsprop.ModificationsPropHelper;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public final class ModificationsPropState
implements AvoidanceReportingState,
AbstractQueryableState,
AbstractStateWithLocation,
LatticeAbstractState<ModificationsPropState>,
Graphable {
    private final boolean isBad;
    private final CFANode locationInModCfa;
    private final CFANode locationInOriginalCfa;
    private final ImmutableSet<String> changedVariables;
    private final Deque<CFANode> originalStack;

    public ModificationsPropState(CFANode pLocationInGivenCfa, CFANode pLocationInOriginalCfa, ImmutableSet<String> pChangedVars, Deque<CFANode> pStack, ModificationsPropHelper pHelper) {
        CFANode nodeInOriginal = pHelper.skipUntrackedOperations(pLocationInOriginalCfa);
        ImmutableSet<String> changedVars = pChangedVars;
        if (!pHelper.isErrorLocation(nodeInOriginal) && pHelper.isErrorLocation(pLocationInGivenCfa)) {
            CFANode nodeInOrigNew = nodeInOriginal;
            do {
                nodeInOriginal = nodeInOrigNew;
                nodeInOrigNew = pHelper.skipUntrackedOperations(nodeInOriginal);
                Pair<CFANode, ImmutableSet<String>> tup = pHelper.skipAssignment(nodeInOrigNew, changedVars);
                nodeInOrigNew = tup.getFirst();
                changedVars = tup.getSecond();
            } while (nodeInOrigNew != nodeInOriginal);
            this.locationInOriginalCfa = nodeInOriginal;
            this.changedVariables = changedVars;
            if (pHelper.isErrorLocation(this.locationInOriginalCfa)) {
                pHelper.logCase("Taking case 3a.");
                this.isBad = false;
            } else {
                pHelper.logCase("Taking case 3b.");
                this.isBad = true;
            }
        } else {
            this.locationInOriginalCfa = nodeInOriginal;
            this.changedVariables = changedVars;
            this.isBad = false;
        }
        this.locationInModCfa = pLocationInGivenCfa;
        this.originalStack = pStack;
    }

    public ModificationsPropState(CFANode pLocationInGivenCfa, CFANode pLocationInOriginalCfa, ImmutableSet<String> pChangedVars, Deque<CFANode> pStack, boolean pIsBad) {
        this.locationInModCfa = pLocationInGivenCfa;
        this.locationInOriginalCfa = pLocationInOriginalCfa;
        this.changedVariables = pChangedVars;
        this.isBad = pIsBad;
        this.originalStack = pStack;
    }

    ModificationsPropState makeBad() {
        return new ModificationsPropState(this.getLocationInModCfa(), this.getLocationInOriginalCfa(), (ImmutableSet<String>)ImmutableSet.of(), new ArrayDeque<CFANode>(), true);
    }

    public CFANode getLocationInOriginalCfa() {
        return this.locationInOriginalCfa;
    }

    public CFANode getLocationInModCfa() {
        return this.locationInModCfa;
    }

    public ImmutableSet<String> getChangedVariables() {
        return this.changedVariables;
    }

    public Deque<CFANode> getOriginalStack() {
        return this.originalStack;
    }

    public boolean isBad() {
        return this.isBad;
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        ModificationsPropState that = (ModificationsPropState)pO;
        return Objects.equals(this.locationInOriginalCfa, that.locationInOriginalCfa) && Objects.equals(this.locationInModCfa, that.locationInModCfa) && Objects.equals(this.changedVariables, that.changedVariables) && Arrays.equals(this.originalStack.toArray(), that.originalStack.toArray()) && this.isBad == that.isBad;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.locationInOriginalCfa, this.locationInModCfa, this.changedVariables, this.isBad);
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.isBad;
    }

    @Override
    public BooleanFormula getReasonFormula(FormulaManagerView pMgr) {
        if (this.mustDumpAssumptionForAvoidance()) {
            return pMgr.getBooleanFormulaManager().makeFalse();
        }
        return pMgr.getBooleanFormulaManager().makeTrue();
    }

    @Override
    public String getCPAName() {
        return ModificationsPropCPA.class.getSimpleName();
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "is_bad": {
                return this.isBad;
            }
        }
        throw new InvalidQueryException("Unknown query to " + this.getClass().getSimpleName() + ": " + pProperty);
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.isBad) {
            sb.append("Uncovered edge");
            if (!this.changedVariables.isEmpty()) {
                sb.append(" for modified variables {");
                for (Object v : this.changedVariables) {
                    sb.append((String)v);
                    sb.append(", ");
                }
                sb.setLength(sb.length() - 2);
                sb.append("}");
            }
            sb.append(":");
            FluentIterable<CFAEdge> edgesInMod = CFAUtils.enteringEdges(this.locationInModCfa);
            for (CFAEdge e : edgesInMod) {
                sb.append(e);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}");
        } else if (!this.changedVariables.isEmpty()) {
            sb.append("Modified: ");
            sb.append("{");
            for (String v : this.changedVariables) {
                sb.append(v);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}");
        } else {
            sb.append("No modification");
        }
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return this.isBad;
    }

    @Override
    public ModificationsPropState join(ModificationsPropState pOther) throws CPAException, InterruptedException {
        assert (this.locationInModCfa.equals(pOther.locationInModCfa));
        assert (this.locationInOriginalCfa.equals(pOther.locationInOriginalCfa));
        assert (Arrays.equals(this.originalStack.toArray(), pOther.originalStack.toArray()));
        if (pOther.isBad() || !this.isBad && pOther.getChangedVariables().containsAll(this.changedVariables)) {
            assert (!pOther.isBad || pOther.getChangedVariables().isEmpty());
            return pOther;
        }
        if (this.isBad || this.changedVariables.containsAll(pOther.getChangedVariables())) {
            assert (!this.isBad || this.changedVariables.isEmpty());
            return this;
        }
        return new ModificationsPropState(this.locationInModCfa, this.locationInOriginalCfa, (ImmutableSet<String>)ImmutableSet.builder().addAll(this.changedVariables).addAll(pOther.changedVariables).build(), this.originalStack, false);
    }

    @Override
    public boolean isLessOrEqual(ModificationsPropState pOther) throws CPAException, InterruptedException {
        return !(!Objects.equals(this.locationInOriginalCfa, pOther.locationInOriginalCfa) || !Objects.equals(this.locationInModCfa, pOther.locationInModCfa) || !Arrays.equals(this.originalStack.toArray(), pOther.originalStack.toArray()) || !pOther.isBad && this.isBad || !pOther.changedVariables.containsAll(this.changedVariables) && !pOther.isBad);
    }

    @Override
    public CFANode getLocationNode() {
        return this.getLocationInModCfa();
    }
}

