/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modificationsprop;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.TestResults;

public class ModificationsPropTest {
    private static final String CONFIG_FILE = "config/differencePropPredicateAnalysis.properties";
    private static final String OLD_SEC = "test/programs/modified/intraprocedural_base_true-unreach-call.c";
    private static final String OLD_UNSEC = "test/programs/modified/intraprocedural_inc_false-unreach-call.c";
    private static final String PROGRAM_ORIGINAL = "test/programs/modified/propbased_diff_original.c";
    private static final String PROGRAM_MODIFIED = "test/programs/modified/propbased_diff_mod.c";
    private static final String FCTCALL_ORIGINAL = "test/programs/modified/function_call_original.c";
    private static final String FCTCALL_MODIFIED = "test/programs/modified/function_call_mod.c";
    private static final String REACH_PROPERTY = "config/properties/unreach-call.prp";
    private static final String DEFAULT_PROPERTY = "config/specification/default.spc";
    private static final String PROP_ORIGINAL_PROGRAM = "differential.program";
    private static final String PROP_REACH_PROPERTY = "differential.badstateProperties";
    private static final String PROP_PREPROCESSING = "differential.performPreprocessing";
    private static final String PROP_DECLARATION_IGNORE = "differential.ignoreDeclarations";
    private static final String PROP_MERGE = "differential.variableSetMerge";
    private static final String PROP_SPEC = "specification";
    private static final String PROP_ENTRY = "analysis.entryFunction";
    private static final String VAL_ENTRY = "main";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    @Test
    public void worksOnDiffcondExample() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)PROP_SPEC, (Object)REACH_PROPERTY, (Object)PROP_ORIGINAL_PROGRAM, (Object)OLD_UNSEC, (Object)PROP_REACH_PROPERTY, (Object)REACH_PROPERTY, (Object)PROP_PREPROCESSING, (Object)TRUE, (Object)PROP_MERGE, (Object)FALSE, (Object)PROP_ENTRY, (Object)VAL_ENTRY);
        TestResults results = CPATestRunner.run(ModificationsPropTest.getProperties(CONFIG_FILE, (Map<String, String>)prop), OLD_SEC);
        results.assertIsSafe();
        prop = ImmutableMap.of((Object)PROP_ORIGINAL_PROGRAM, (Object)OLD_SEC, (Object)PROP_REACH_PROPERTY, (Object)REACH_PROPERTY, (Object)PROP_PREPROCESSING, (Object)TRUE, (Object)PROP_MERGE, (Object)FALSE, (Object)PROP_SPEC, (Object)REACH_PROPERTY, (Object)PROP_DECLARATION_IGNORE, (Object)FALSE, (Object)PROP_ENTRY, (Object)VAL_ENTRY);
        results = CPATestRunner.run(ModificationsPropTest.getProperties(CONFIG_FILE, (Map<String, String>)prop), OLD_UNSEC);
        results.assertIsUnsafe();
        prop = ImmutableMap.of((Object)PROP_ORIGINAL_PROGRAM, (Object)OLD_UNSEC, (Object)PROP_REACH_PROPERTY, (Object)DEFAULT_PROPERTY, (Object)PROP_PREPROCESSING, (Object)TRUE, (Object)PROP_MERGE, (Object)FALSE, (Object)PROP_SPEC, (Object)DEFAULT_PROPERTY, (Object)PROP_DECLARATION_IGNORE, (Object)FALSE);
        results = CPATestRunner.run(ModificationsPropTest.getProperties(CONFIG_FILE, (Map<String, String>)prop), OLD_SEC);
        results.assertIsSafe();
        prop = ImmutableMap.of((Object)PROP_ORIGINAL_PROGRAM, (Object)OLD_SEC, (Object)PROP_REACH_PROPERTY, (Object)DEFAULT_PROPERTY, (Object)PROP_PREPROCESSING, (Object)TRUE, (Object)PROP_SPEC, (Object)DEFAULT_PROPERTY, (Object)PROP_MERGE, (Object)FALSE, (Object)PROP_DECLARATION_IGNORE, (Object)FALSE);
        results = CPATestRunner.run(ModificationsPropTest.getProperties(CONFIG_FILE, (Map<String, String>)prop), OLD_UNSEC);
        results.assertIsUnsafe();
    }

    @Test
    public void successfulCoverage() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)PROP_ORIGINAL_PROGRAM, (Object)PROGRAM_ORIGINAL, (Object)PROP_REACH_PROPERTY, (Object)REACH_PROPERTY, (Object)PROP_PREPROCESSING, (Object)FALSE, (Object)PROP_MERGE, (Object)FALSE, (Object)PROP_SPEC, (Object)REACH_PROPERTY, (Object)PROP_DECLARATION_IGNORE, (Object)FALSE, (Object)PROP_ENTRY, (Object)VAL_ENTRY);
        TestResults results = CPATestRunner.run(ModificationsPropTest.getProperties(CONFIG_FILE, (Map<String, String>)prop), PROGRAM_MODIFIED);
        results.assertIsSafe();
    }

    @Test
    public void functionCalls() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)PROP_ORIGINAL_PROGRAM, (Object)FCTCALL_ORIGINAL, (Object)PROP_REACH_PROPERTY, (Object)REACH_PROPERTY, (Object)PROP_PREPROCESSING, (Object)TRUE, (Object)PROP_MERGE, (Object)FALSE, (Object)PROP_SPEC, (Object)REACH_PROPERTY, (Object)PROP_DECLARATION_IGNORE, (Object)TRUE, (Object)PROP_ENTRY, (Object)VAL_ENTRY);
        TestResults results = CPATestRunner.run(ModificationsPropTest.getProperties(CONFIG_FILE, (Map<String, String>)prop), FCTCALL_MODIFIED);
        results.assertIsSafe();
        prop = ImmutableMap.of((Object)PROP_ORIGINAL_PROGRAM, (Object)FCTCALL_ORIGINAL, (Object)PROP_REACH_PROPERTY, (Object)REACH_PROPERTY, (Object)PROP_PREPROCESSING, (Object)TRUE, (Object)PROP_MERGE, (Object)FALSE, (Object)PROP_SPEC, (Object)REACH_PROPERTY, (Object)PROP_DECLARATION_IGNORE, (Object)FALSE, (Object)PROP_ENTRY, (Object)VAL_ENTRY);
        results = CPATestRunner.run(ModificationsPropTest.getProperties(CONFIG_FILE, (Map<String, String>)prop), FCTCALL_MODIFIED);
        results.assertIsUnsafe();
    }

    @Test
    public void correctFail() throws Exception {
        ImmutableMap prop = ImmutableMap.of((Object)PROP_ORIGINAL_PROGRAM, (Object)PROGRAM_MODIFIED, (Object)PROP_REACH_PROPERTY, (Object)REACH_PROPERTY, (Object)PROP_PREPROCESSING, (Object)TRUE, (Object)PROP_MERGE, (Object)FALSE, (Object)PROP_SPEC, (Object)REACH_PROPERTY, (Object)PROP_DECLARATION_IGNORE, (Object)FALSE, (Object)PROP_ENTRY, (Object)VAL_ENTRY);
        TestResults results = CPATestRunner.run(ModificationsPropTest.getProperties(CONFIG_FILE, (Map<String, String>)prop), PROGRAM_ORIGINAL);
        results.assertIsUnsafe();
    }

    private static Configuration getProperties(String pConfigFile, Map<String, String> pOverrideOptions) throws InvalidConfigurationException, IOException {
        ConfigurationBuilder configBuilder = TestDataTools.configurationForTest().loadFromFile(pConfigFile);
        return configBuilder.setOptions(pOverrideOptions).build();
    }
}

