/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modificationsprop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CCfaEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.modificationsprop.ModificationsPropHelper;
import org.sosy_lab.cpachecker.cpa.modificationsprop.ModificationsPropState;
import org.sosy_lab.cpachecker.cpa.modificationsprop.PointerAccessException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAEdgeUtils;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

public class ModificationsPropTransferRelation
extends SingleEdgeTransferRelation {
    private final ModificationsPropHelper helper;

    public ModificationsPropTransferRelation(ModificationsPropHelper pHelper) {
        this.helper = pHelper;
    }

    public Collection<ModificationsPropState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        return this.getAbstractSuccessorsForEdge(pState, pPrecision, pCfaEdge, null);
    }

    private Collection<ModificationsPropState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge, @Nullable CFANode emergencyStop) throws CPATransferException, InterruptedException {
        ModificationsPropState modPropState = (ModificationsPropState)pState;
        CFANode nodeInMod = modPropState.getLocationInModCfa();
        CFANode nodeInOriginal = modPropState.getLocationInOriginalCfa();
        ImmutableSet changedVars = modPropState.getChangedVariables();
        Deque<CFANode> stack = modPropState.getOriginalStack();
        if (!modPropState.isBad()) {
            if (!this.helper.isErrorLocation(nodeInOriginal) && this.helper.mayReachErrorLocation(nodeInMod, false)) {
                if (!this.helper.mayReachErrorLocation(nodeInOriginal, true)) {
                    this.helper.logCase("Original program cannot reach an error location anymore. Making state bad.");
                    return ImmutableSet.of((Object)modPropState.makeBad());
                }
                if (CFAUtils.leavingEdges(nodeInMod).contains((Object)pCfaEdge)) {
                    String lhsVar;
                    if (this.helper.isUntracked(pCfaEdge)) {
                        this.helper.logCase("Skipping ignored CFA edge for given program.");
                        return ImmutableSet.of((Object)new ModificationsPropState(pCfaEdge.getSuccessor(), nodeInOriginal, changedVars, stack, this.helper));
                    }
                    for (CFAEdge edgeInOriginal : CFAUtils.leavingEdges(nodeInOriginal)) {
                        ImmutableSet<String> changedVarsInSuccessor;
                        if (!this.helper.edgesMatchIgnoringFunctionReturnLocation(pCfaEdge, edgeInOriginal)) continue;
                        if (pCfaEdge instanceof CAssumeEdge && this.helper.areVariablesUsedInEdge(pCfaEdge, changedVars) || !(pCfaEdge instanceof CCfaEdge)) {
                            this.helper.logCase("Taking case 4a.");
                            return ImmutableSet.of((Object)modPropState.makeBad());
                        }
                        if (pCfaEdge instanceof BlankEdge || pCfaEdge instanceof CAssumeEdge || pCfaEdge instanceof CFunctionSummaryEdge || pCfaEdge instanceof CDeclarationEdge || pCfaEdge instanceof CReturnStatementEdge && !this.helper.areVariablesUsedInEdge(pCfaEdge, changedVars)) {
                            this.helper.logCase("Taking case 4b.");
                            return ImmutableSet.of((Object)new ModificationsPropState(pCfaEdge.getSuccessor(), edgeInOriginal.getSuccessor(), changedVars, stack, this.helper));
                        }
                        if (!(pCfaEdge instanceof CStatementEdge)) continue;
                        this.helper.logCase("Taking case 4b.");
                        try {
                            changedVarsInSuccessor = this.helper.modifySetForAssignment((CStatementEdge)pCfaEdge, changedVars);
                        }
                        catch (PointerAccessException e) {
                            this.helper.logProblem("Caution: Pointer or similar detected.");
                            return ImmutableSet.of((Object)modPropState.makeBad());
                        }
                        return ImmutableSet.of((Object)new ModificationsPropState(pCfaEdge.getSuccessor(), edgeInOriginal.getSuccessor(), changedVarsInSuccessor, stack, this.helper));
                    }
                    if (pCfaEdge instanceof CDeclarationEdge) {
                        for (CFAEdge edgeInOriginal : CFAUtils.leavingEdges(nodeInOriginal)) {
                            if (!(edgeInOriginal instanceof CDeclarationEdge)) continue;
                            CDeclaration declOr = ((CDeclarationEdge)edgeInOriginal).getDeclaration();
                            CDeclaration declMo = ((CDeclarationEdge)pCfaEdge).getDeclaration();
                            if (declOr.getOrigName() == null || !declOr.getOrigName().equals(declMo.getOrigName())) continue;
                            this.helper.logCase("Taking case 4 for different declarations or modified variables.");
                            return ImmutableSet.of((Object)new ModificationsPropState(pCfaEdge.getSuccessor(), edgeInOriginal.getSuccessor(), (ImmutableSet<String>)new ImmutableSet.Builder().addAll(changedVars).add((Object)declOr.getQualifiedName()).build(), stack, this.helper));
                        }
                    }
                    if (pCfaEdge instanceof CReturnStatementEdge) {
                        for (CFAEdge edgeInOriginal : CFAUtils.leavingEdges(nodeInOriginal)) {
                            if (!(edgeInOriginal instanceof CReturnStatementEdge)) continue;
                            CReturnStatementEdge retOr = (CReturnStatementEdge)edgeInOriginal;
                            CReturnStatementEdge retMo = (CReturnStatementEdge)pCfaEdge;
                            if (!this.helper.inSameFunction(retMo.getSuccessor(), retOr.getSuccessor())) continue;
                            this.helper.logCase("Taking case 4 for function returns, potentially with modified variables or different statements.");
                            try {
                                ImmutableSet returnChangedVars;
                                if (retMo.getReturnStatement() == null || retOr.getReturnStatement() == null || retMo.getReturnStatement().equals(retOr.getReturnStatement()) && retMo.getReturnStatement().asAssignment().isEmpty()) {
                                    returnChangedVars = changedVars;
                                } else if (retMo.getReturnStatement().equals(retOr.getReturnStatement()) && Collections.disjoint((Collection)retMo.getReturnStatement().asAssignment().orElseThrow().getRightHandSide().accept(this.helper.getVisitor()), changedVars)) {
                                    ImmutableSet.Builder builder = new ImmutableSet.Builder();
                                    Set<String> leftVars = retMo.getReturnStatement().asAssignment().orElseThrow().getLeftHandSide().accept(this.helper.getVisitor());
                                    for (String var : changedVars) {
                                        if (leftVars.contains(var)) continue;
                                        builder.add((Object)var);
                                    }
                                    returnChangedVars = builder.build();
                                } else {
                                    returnChangedVars = new ImmutableSet.Builder().addAll(changedVars).addAll(retMo.getReturnStatement().asAssignment().isPresent() ? (Iterable)retMo.getReturnStatement().asAssignment().orElseThrow().getLeftHandSide().accept(this.helper.getVisitor()) : ImmutableSet.of()).addAll(retOr.getReturnStatement().asAssignment().isPresent() ? (Iterable)retOr.getReturnStatement().asAssignment().orElseThrow().getLeftHandSide().accept(this.helper.getVisitor()) : ImmutableSet.of()).build();
                                }
                                return ImmutableSet.of((Object)new ModificationsPropState(pCfaEdge.getSuccessor(), edgeInOriginal.getSuccessor(), returnChangedVars, stack, this.helper));
                            }
                            catch (PointerAccessException e) {
                                this.helper.logProblem("Caution: Pointer or similar detected.");
                                return ImmutableSet.of((Object)modPropState.makeBad());
                            }
                        }
                    }
                    if (pCfaEdge instanceof CFunctionReturnEdge) {
                        ArrayDeque<CFANode> stackminus = new ArrayDeque<CFANode>(stack);
                        CFANode summaryGoal = (CFANode)stackminus.removeLast();
                        if (summaryGoal != null) {
                            for (CFAEdge edgeInOriginal : CFAUtils.leavingEdges(nodeInOriginal)) {
                                if (!(edgeInOriginal instanceof CFunctionReturnEdge) || !edgeInOriginal.getSuccessor().equals(summaryGoal)) continue;
                                CFunctionReturnEdge retOr = (CFunctionReturnEdge)edgeInOriginal;
                                CFunctionReturnEdge retMo = (CFunctionReturnEdge)pCfaEdge;
                                if (!this.helper.inSameFunction(retMo.getSuccessor(), retOr.getSuccessor())) continue;
                                this.helper.logCase("Taking case 4 for function return statement with modified variables or different statements.");
                                CFunctionCall summaryOr = retOr.getSummaryEdge().getExpression();
                                CFunctionCall summaryMo = retOr.getSummaryEdge().getExpression();
                                if (summaryOr instanceof CFunctionCallAssignmentStatement && summaryMo instanceof CFunctionCallAssignmentStatement) {
                                    CFunctionCallAssignmentStatement summaryOrAss = (CFunctionCallAssignmentStatement)summaryOr;
                                    CFunctionCallAssignmentStatement summaryMoAss = (CFunctionCallAssignmentStatement)summaryMo;
                                    try {
                                        Optional<CVariableDeclaration> retVarDecl = retMo.getFunctionEntry().getReturnVariable();
                                        if (!summaryOrAss.getLeftHandSide().equals(summaryMoAss.getLeftHandSide()) || retVarDecl.isPresent() && changedVars.contains((Object)retVarDecl.orElseThrow().getQualifiedName()) || !summaryOrAss.getRightHandSide().equals(summaryMoAss.getRightHandSide())) {
                                            return ImmutableSet.of((Object)new ModificationsPropState(pCfaEdge.getSuccessor(), edgeInOriginal.getSuccessor(), (ImmutableSet<String>)new ImmutableSet.Builder().addAll((Iterable)changedVars).addAll((Iterable)summaryMoAss.getLeftHandSide().accept(this.helper.getVisitor())).addAll((Iterable)summaryOrAss.getLeftHandSide().accept(this.helper.getVisitor())).build(), (Deque<CFANode>)stackminus, this.helper));
                                        }
                                    }
                                    catch (PointerAccessException e) {
                                        this.helper.logProblem("Caution: Pointer or similar detected.");
                                        return ImmutableSet.of((Object)modPropState.makeBad());
                                    }
                                }
                                if (summaryOr instanceof CFunctionCallAssignmentStatement ^ summaryMo instanceof CFunctionCallAssignmentStatement) {
                                    this.helper.logCase("Assignment and non-assignment with call of same function. Stopping here.");
                                    return ImmutableSet.of((Object)modPropState.makeBad());
                                }
                                return ImmutableSet.of((Object)new ModificationsPropState(pCfaEdge.getSuccessor(), edgeInOriginal.getSuccessor(), (ImmutableSet<String>)changedVars, (Deque<CFANode>)stackminus, this.helper));
                            }
                        } else {
                            this.helper.logProblem("Stack is empty. Something went wrong.");
                        }
                    }
                    if (pCfaEdge instanceof CFunctionCallEdge) {
                        for (CFAEdge edgeInOriginal : CFAUtils.leavingEdges(nodeInOriginal)) {
                            if (!(edgeInOriginal instanceof CFunctionCallEdge)) continue;
                            CFunctionCallEdge callOr = (CFunctionCallEdge)edgeInOriginal;
                            CFunctionCallEdge callMo = (CFunctionCallEdge)pCfaEdge;
                            CFunctionEntryNode entryNodeOr = callOr.getSuccessor();
                            CFunctionEntryNode entryNodeMo = callMo.getSuccessor();
                            ImmutableList paramsOr = Collections3.transformedImmutableListCopy(entryNodeOr.getFunctionParameters(), param -> param.getQualifiedName());
                            ImmutableList paramsMo = Collections3.transformedImmutableListCopy(entryNodeMo.getFunctionParameters(), param -> param.getQualifiedName());
                            if (!paramsMo.containsAll((Collection<?>)paramsOr) || !this.helper.inSameFunction(entryNodeMo, entryNodeOr)) continue;
                            this.helper.logCase("Taking case 4 for function calls with modified variables.");
                            HashSet<String> modifiedAfterFunctionCall = new HashSet<String>((Collection<String>)changedVars);
                            for (String param2 : paramsOr) {
                                try {
                                    if (!callMo.getArguments().get(paramsMo.indexOf(param2)).equals(callOr.getArguments().get(paramsOr.indexOf(param2))) || !Collections.disjoint((Collection)callMo.getArguments().get(paramsMo.indexOf(param2)).accept(this.helper.getVisitor()), changedVars)) {
                                        modifiedAfterFunctionCall.add(param2);
                                        continue;
                                    }
                                    if (!changedVars.contains((Object)param2)) continue;
                                    modifiedAfterFunctionCall.remove(param2);
                                }
                                catch (PointerAccessException e) {
                                    this.helper.logProblem("Caution: Pointer or similar detected.");
                                    return ImmutableSet.of((Object)modPropState.makeBad());
                                }
                            }
                            ArrayDeque<CFANode> stackplus = new ArrayDeque<CFANode>(stack);
                            FunctionSummaryEdge summaryEdge = nodeInOriginal.getLeavingSummaryEdge();
                            if (summaryEdge != null) {
                                stackplus.addLast(nodeInOriginal.getLeavingSummaryEdge().getSuccessor());
                            } else {
                                this.helper.logProblem("Function call without summary edge found. This is not critical yet, but might indicate a problem.");
                            }
                            return ImmutableSet.of((Object)new ModificationsPropState(pCfaEdge.getSuccessor(), edgeInOriginal.getSuccessor(), (ImmutableSet<String>)new ImmutableSet.Builder().addAll(modifiedAfterFunctionCall).build(), stackplus, this.helper));
                        }
                    }
                    Pair<CFANode, ImmutableSet<String>> givenTup = this.helper.skipAssignment(nodeInMod, changedVars);
                    Pair<CFANode, ImmutableSet<String>> originalTup = this.helper.skipAssignment(nodeInOriginal, changedVars);
                    if (!givenTup.getFirst().equals(nodeInMod) && !originalTup.getFirst().equals(nodeInOriginal) && (lhsVar = CFAEdgeUtils.getLeftHandVariable(nodeInMod.getLeavingEdge(0))) != null && lhsVar.equals(CFAEdgeUtils.getLeftHandVariable(nodeInOriginal.getLeavingEdge(0)))) {
                        this.helper.logCase("Combining cases 5 and 6 for same variable.");
                        return ImmutableSet.of((Object)new ModificationsPropState(givenTup.getFirst(), originalTup.getFirst(), givenTup.getSecond(), stack, this.helper));
                    }
                    Pair<CFANode, ImmutableSet<String>> tup = this.helper.skipAssignment(nodeInMod, changedVars);
                    if (!tup.getFirst().equals(nodeInMod)) {
                        this.helper.logCase("Taking case 5.");
                        return ImmutableSet.of((Object)new ModificationsPropState(tup.getFirst(), nodeInOriginal, tup.getSecond(), stack, this.helper));
                    }
                    tup = this.helper.skipAssignment(nodeInOriginal, changedVars);
                    if (!tup.getFirst().equals(nodeInOriginal)) {
                        this.helper.logCase("Taking case 6.");
                        if (emergencyStop != null && emergencyStop.equals(tup.getFirst())) {
                            this.helper.logProblem("Found infinite sequence of assignments in original program.");
                            return ImmutableSet.of((Object)modPropState.makeBad());
                        }
                        return this.getAbstractSuccessorsForEdge(new ModificationsPropState(nodeInMod, tup.getFirst(), tup.getSecond(), stack, this.helper), pPrecision, pCfaEdge, null);
                    }
                    if (this.helper.useImplicationCheck() && pCfaEdge instanceof CAssumeEdge) {
                        CAssumeEdge assGiven = (CAssumeEdge)pCfaEdge;
                        for (CFAEdge ce : CFAUtils.leavingEdges(nodeInOriginal)) {
                            if (!(ce instanceof CAssumeEdge)) continue;
                            CAssumeEdge assOrig = (CAssumeEdge)ce;
                            this.helper.logCase("Checking for case 7 compliance.");
                            if (this.helper.implies(assGiven, assOrig)) {
                                Set<String> varsInAssOrig;
                                Set<String> varsInAssGiven;
                                try {
                                    varsInAssGiven = assGiven.getExpression().accept(this.helper.getVisitor());
                                    varsInAssOrig = assOrig.getExpression().accept(this.helper.getVisitor());
                                }
                                catch (PointerAccessException e) {
                                    this.helper.logProblem("Caution: Pointer or similar detected.");
                                    return ImmutableSet.of((Object)modPropState.makeBad());
                                }
                                ImmutableSet varsUsedInBoth = new ImmutableSet.Builder().addAll(varsInAssGiven).addAll(varsInAssOrig).build();
                                if (Collections.disjoint(changedVars, varsUsedInBoth)) {
                                    this.helper.logCase("Taking case 7a.");
                                    return ImmutableSet.of((Object)new ModificationsPropState(assGiven.getSuccessor(), assOrig.getSuccessor(), (ImmutableSet<String>)changedVars, stack, this.helper));
                                }
                                this.helper.logCase("Taking case 7b.");
                                return ImmutableSet.of((Object)modPropState.makeBad());
                            }
                            this.helper.logCase("No implication. Continuing.");
                        }
                    }
                    if (pCfaEdge instanceof CAssumeEdge) {
                        this.helper.logCase("Taking case 8.");
                        return ImmutableSet.of((Object)new ModificationsPropState(pCfaEdge.getSuccessor(), nodeInOriginal, changedVars, stack, this.helper));
                    }
                    this.helper.logCase("Taking case 9.");
                    return ImmutableSet.of((Object)modPropState.makeBad());
                }
            }
            if (this.helper.isErrorLocation(nodeInOriginal)) {
                this.helper.logCase("Taking case 2.");
            } else {
                this.helper.logCase("No error location reachable. Stopping here.");
            }
        }
        return ImmutableSet.of();
    }
}

