/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modificationsprop;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.modificationsprop.PointerAccessException;

public class VariableIdentifierVisitor
extends DefaultCExpressionVisitor<Set<String>, PointerAccessException>
implements CRightHandSideVisitor<Set<String>, PointerAccessException>,
CLeftHandSideVisitor<Set<String>, PointerAccessException> {
    private final boolean disallowPointers;

    public VariableIdentifierVisitor(boolean pDisallowPointers) {
        this.disallowPointers = pDisallowPointers;
    }

    @Override
    public Set<String> visit(CFunctionCallExpression pExp) throws PointerAccessException {
        Set<String> resultSet = pExp.getFunctionNameExpression().accept(this);
        for (CExpression exp : pExp.getParameterExpressions()) {
            resultSet.addAll((Collection<String>)exp.accept(this));
        }
        return resultSet;
    }

    @Override
    protected Set<String> visitDefault(CExpression pExp) throws PointerAccessException {
        return new HashSet<String>();
    }

    @Override
    public Set<String> visit(CArraySubscriptExpression pExp) throws PointerAccessException {
        Set<String> resultSet = pExp.getArrayExpression().accept(this);
        resultSet.addAll((Collection<String>)pExp.getSubscriptExpression().accept(this));
        return resultSet;
    }

    @Override
    public Set<String> visit(CBinaryExpression pExp) throws PointerAccessException {
        Set<String> resultSet = pExp.getOperand1().accept(this);
        resultSet.addAll((Collection<String>)pExp.getOperand2().accept(this));
        return resultSet;
    }

    @Override
    public Set<String> visit(CCastExpression pExp) throws PointerAccessException {
        return pExp.getOperand().accept(this);
    }

    @Override
    public Set<String> visit(CComplexCastExpression pExp) throws PointerAccessException {
        return pExp.getOperand().accept(this);
    }

    @Override
    public Set<String> visit(CFieldReference pExp) throws PointerAccessException {
        if (this.disallowPointers && (pExp.isPointerDereference() || pExp.getFieldOwner().getExpressionType().getCanonicalType() instanceof CPointerType)) {
            throw new PointerAccessException();
        }
        return pExp.getFieldOwner().accept(this);
    }

    @Override
    public Set<String> visit(CIdExpression pExp) throws PointerAccessException {
        if (pExp.getDeclaration() != null) {
            return Sets.newHashSet((Object[])new String[]{pExp.getDeclaration().getQualifiedName()});
        }
        return Sets.newHashSet((Object[])new String[]{pExp.getName()});
    }

    @Override
    public Set<String> visit(CUnaryExpression pExp) throws PointerAccessException {
        return pExp.getOperand().accept(this);
    }

    @Override
    public Set<String> visit(CPointerExpression pExp) throws PointerAccessException {
        if (this.disallowPointers) {
            throw new PointerAccessException();
        }
        return pExp.getOperand().accept(this);
    }
}

