/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modificationsrcd;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.modificationsrcd.ModificationsRcdState;
import org.sosy_lab.cpachecker.cpa.modificationsrcd.ModificationsRcdTransferRelation;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFATraversal;

@Options(prefix="differential")
public class ModificationsRcdCPA
implements ConfigurableProgramAnalysis {
    @Option(secure=true, description="Program to check against", name="program", required=true)
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path originalProgram = null;
    @Option(secure=true, description="ignore declarations when detecting modifications, be careful when variables are renamed (could be unsound)")
    private boolean ignoreDeclarations = false;
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfaForComparison;
    private final TransferRelation transfer;
    private final DelegateAbstractDomain<ModificationsRcdState> domain;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ModificationsRcdCPA.class);
    }

    @SuppressFBWarnings(value={"NP"})
    public ModificationsRcdCPA(CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.domain = DelegateAbstractDomain.getInstance();
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        CFACreator cfaCreator = new CFACreator(this.config, this.logger, this.shutdownNotifier);
        try {
            this.cfaForComparison = cfaCreator.parseFileAndCreateCFA((List<String>)ImmutableList.of((Object)this.originalProgram.toString()));
            if (this.ignoreDeclarations) {
                CFATraversal.DeclarationCollectingCFAVisitor varDeclCollect = new CFATraversal.DeclarationCollectingCFAVisitor();
                CFATraversal.dfs().traverse(this.cfaForComparison.getMainFunction(), varDeclCollect);
                Map<String, Set<String>> origFunToDeclNames = varDeclCollect.getVisitedDeclarations();
                varDeclCollect = new CFATraversal.DeclarationCollectingCFAVisitor();
                CFATraversal.dfs().traverse(pCfa.getMainFunction(), varDeclCollect);
                this.transfer = new ModificationsRcdTransferRelation(true, origFunToDeclNames, varDeclCollect.getVisitedDeclarations());
            } else {
                this.transfer = new ModificationsRcdTransferRelation();
            }
        }
        catch (ParserException pE) {
            throw new InvalidConfigurationException("Parser error for originalProgram", (Throwable)pE);
        }
        catch (IOException | InterruptedException pE) {
            throw new AssertionError((Object)pE);
        }
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.getAbstractDomain());
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return new ModificationsRcdState(node, this.cfaForComparison.getMainFunction(), (ImmutableSet<String>)ImmutableSet.of());
    }
}

