/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modificationsrcd;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.cpa.modificationsrcd.ModificationsRcdCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public final class ModificationsRcdState
implements AvoidanceReportingState,
AbstractQueryableState,
LatticeAbstractState<ModificationsRcdState>,
Graphable {
    private boolean hasRelevantModification;
    private CFANode locationInGivenCfa;
    private CFANode locationInOriginalCfa;
    private ImmutableSet<String> changedVarsInGivenCfa;

    public ModificationsRcdState(CFANode pLocationInGivenCfa, CFANode pLocationInOriginalCfa, ImmutableSet<String> pChangedVarsInGivenCfa) {
        this(pLocationInGivenCfa, pLocationInOriginalCfa, pChangedVarsInGivenCfa, false);
    }

    public ModificationsRcdState(CFANode pLocationInGivenCfa, CFANode pLocationInOriginalCfa, ImmutableSet<String> pChangedVarsInGivenCfa, boolean pHasRelevantModification) {
        this.locationInGivenCfa = pLocationInGivenCfa;
        this.locationInOriginalCfa = pLocationInOriginalCfa;
        this.changedVarsInGivenCfa = pChangedVarsInGivenCfa;
        this.hasRelevantModification = pHasRelevantModification;
    }

    public CFANode getLocationInOriginalCfa() {
        return this.locationInOriginalCfa;
    }

    public CFANode getLocationInGivenCfa() {
        return this.locationInGivenCfa;
    }

    public ImmutableSet<String> getChangedVarsInGivenCfa() {
        return this.changedVarsInGivenCfa;
    }

    public boolean hasRelevantModification() {
        return this.hasRelevantModification;
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        ModificationsRcdState that = (ModificationsRcdState)pO;
        return Objects.equals(this.locationInOriginalCfa, that.locationInOriginalCfa) && Objects.equals(this.locationInGivenCfa, that.locationInGivenCfa) && Objects.equals(this.changedVarsInGivenCfa, that.changedVarsInGivenCfa) && this.hasRelevantModification == that.hasRelevantModification;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.locationInOriginalCfa, this.locationInGivenCfa, this.changedVarsInGivenCfa, this.hasRelevantModification);
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.hasRelevantModification;
    }

    @Override
    public BooleanFormula getReasonFormula(FormulaManagerView pMgr) {
        if (this.mustDumpAssumptionForAvoidance()) {
            return pMgr.getBooleanFormulaManager().makeFalse();
        }
        return pMgr.getBooleanFormulaManager().makeTrue();
    }

    @Override
    public String getCPAName() {
        return ModificationsRcdCPA.class.getSimpleName();
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "is_modified": {
                return this.hasRelevantModification;
            }
        }
        throw new InvalidQueryException("Unknown query to " + this.getClass().getSimpleName() + ": " + pProperty);
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.hasRelevantModification) {
            sb.append("Misfit: ");
            FluentIterable<CFAEdge> edgesInOrig = CFAUtils.enteringEdges(this.locationInOriginalCfa);
            sb.append("{");
            for (CFAEdge e : edgesInOrig) {
                sb.append(e);
                sb.append(", ");
            }
            sb.append("}");
        } else if (!this.changedVarsInGivenCfa.isEmpty()) {
            sb.append("Reaching changed definitions: ");
            sb.append("{");
            for (String v : this.changedVarsInGivenCfa) {
                sb.append(v);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}");
        } else {
            sb.append("No modification");
        }
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return this.hasRelevantModification;
    }

    @Override
    public ModificationsRcdState join(ModificationsRcdState pOther) throws CPAException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLessOrEqual(ModificationsRcdState pOther) throws CPAException, InterruptedException {
        return Objects.equals(this.locationInOriginalCfa, pOther.locationInOriginalCfa) && Objects.equals(this.locationInGivenCfa, pOther.locationInGivenCfa) && this.hasRelevantModification == pOther.hasRelevantModification && pOther.changedVarsInGivenCfa.containsAll(this.changedVarsInGivenCfa);
    }
}

