/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.modificationsrcd;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.modificationsrcd.ModificationsRcdState;
import org.sosy_lab.cpachecker.cpa.modificationsrcd.VariableIdentifierVisitor;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAEdgeUtils;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class ModificationsRcdTransferRelation
extends SingleEdgeTransferRelation {
    private final boolean ignoreDeclarations;
    private final Map<String, Set<String>> funToVarsOrig;
    private final Map<String, Set<String>> funToVarsGiven;

    public ModificationsRcdTransferRelation(boolean pIgnoreDeclarations, Map<String, Set<String>> pFunToVarsOrig, Map<String, Set<String>> pFunToVarsGiven) {
        this.ignoreDeclarations = pIgnoreDeclarations;
        this.funToVarsOrig = pFunToVarsOrig;
        this.funToVarsGiven = pFunToVarsGiven;
    }

    public ModificationsRcdTransferRelation() {
        this(false, (Map<String, Set<String>>)ImmutableMap.of(), (Map<String, Set<String>>)ImmutableMap.of());
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        ModificationsRcdState locations = (ModificationsRcdState)pState;
        if (!locations.hasRelevantModification()) {
            CFANode nodeInGiven = locations.getLocationInGivenCfa();
            CFANode nodeInOriginal = locations.getLocationInOriginalCfa();
            ImmutableSet<String> changedVarsInGiven = locations.getChangedVarsInGivenCfa();
            if (CFAUtils.leavingEdges(nodeInGiven).contains((Object)pCfaEdge)) {
                CFANode succInGiven = pCfaEdge.getSuccessor();
                HashSet<ModificationsRcdState> successors = new HashSet<ModificationsRcdState>();
                for (CFAEdge edgeInOriginal : CFAUtils.leavingEdges(nodeInOriginal)) {
                    Optional<ModificationsRcdState> potSucc = this.findMatchingSuccessor(pCfaEdge, edgeInOriginal, changedVarsInGiven);
                    if (!potSucc.isPresent()) continue;
                    if (this.variablesAreUsedInEdge(edgeInOriginal, changedVarsInGiven) || this.variablesAreUsedInEdge(pCfaEdge, changedVarsInGiven)) break;
                    successors.add(potSucc.orElseThrow());
                    break;
                }
                if (successors.isEmpty()) {
                    for (CFAEdge edgeInOriginal : CFAUtils.leavingEdges(nodeInOriginal)) {
                        successors.add(new ModificationsRcdState(succInGiven, edgeInOriginal.getSuccessor(), (ImmutableSet<String>)ImmutableSet.of(), true));
                    }
                }
                assert (!successors.isEmpty()) : "List of successors should never be empty if previous state represents no modification";
                return successors;
            }
        }
        return ImmutableSet.of();
    }

    private Optional<ModificationsRcdState> findMatchingSuccessor(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal, ImmutableSet<String> pChangedVarsInGiven) {
        boolean stuttered;
        CFAEdge originalEdge = pEdgeInOriginal;
        do {
            Optional<String> changed;
            Optional<String> deleted;
            ImmutableSet<String> changedVarsInSuccessor;
            Optional<String> added;
            stuttered = false;
            if (this.edgesMatch(pEdgeInGiven, originalEdge)) {
                ImmutableSet<String> changedVarsInSuccessor2 = this.removeVariableFromSetIfAssignedInEdge(originalEdge, pChangedVarsInGiven);
                return Optional.of(new ModificationsRcdState(pEdgeInGiven.getSuccessor(), originalEdge.getSuccessor(), changedVarsInSuccessor2));
            }
            if (pEdgeInGiven.getPredecessor().getNumLeavingEdges() == 1 && (added = this.checkEdgeAddedAssignment(pEdgeInGiven, originalEdge)).isPresent()) {
                changedVarsInSuccessor = new ImmutableSet.Builder().addAll(pChangedVarsInGiven).add((Object)added.orElseThrow()).build();
                return Optional.of(new ModificationsRcdState(pEdgeInGiven.getSuccessor(), originalEdge.getPredecessor(), changedVarsInSuccessor));
            }
            if (originalEdge.getPredecessor().getNumLeavingEdges() == 1 && (deleted = this.checkEdgeDeletedAssignment(pEdgeInGiven, originalEdge)).isPresent()) {
                changedVarsInSuccessor = new ImmutableSet.Builder().addAll(pChangedVarsInGiven).add((Object)deleted.orElseThrow()).build();
                if (this.variablesAreUsedInEdge(pEdgeInGiven, (ImmutableSet<String>)ImmutableSet.of((Object)deleted.orElseThrow()))) {
                    return Optional.empty();
                }
                for (CFAEdge edgeLeavingOrigSuccessor : CFAUtils.leavingEdges(originalEdge.getSuccessor())) {
                    if (!this.edgesMatch(pEdgeInGiven, edgeLeavingOrigSuccessor)) continue;
                    changedVarsInSuccessor = this.removeVariableFromSetIfAssignedInEdge(pEdgeInGiven, changedVarsInSuccessor);
                    return Optional.of(new ModificationsRcdState(pEdgeInGiven.getSuccessor(), edgeLeavingOrigSuccessor.getSuccessor(), changedVarsInSuccessor));
                }
            }
            if (originalEdge.getPredecessor().getNumLeavingEdges() == 1 && pEdgeInGiven.getPredecessor().getNumLeavingEdges() == 1 && (changed = this.checkEdgeChangedAssignment(pEdgeInGiven, originalEdge)).isPresent()) {
                changedVarsInSuccessor = new ImmutableSet.Builder().addAll(pChangedVarsInGiven).add((Object)changed.orElseThrow()).build();
                return Optional.of(new ModificationsRcdState(pEdgeInGiven.getSuccessor(), originalEdge.getSuccessor(), changedVarsInSuccessor));
            }
            if (!this.ignoreDeclarations) continue;
            if (pEdgeInGiven instanceof CDeclarationEdge && !this.declarationNameAlreadyExistsInOtherCFA(true, (CDeclarationEdge)pEdgeInGiven)) {
                return Optional.of(new ModificationsRcdState(pEdgeInGiven.getSuccessor(), originalEdge.getPredecessor(), pChangedVarsInGiven));
            }
            if (!(originalEdge instanceof CDeclarationEdge) || this.declarationNameAlreadyExistsInOtherCFA(false, (CDeclarationEdge)originalEdge) || originalEdge.getSuccessor().getNumLeavingEdges() != 1) continue;
            originalEdge = originalEdge.getSuccessor().getLeavingEdge(0);
            stuttered = true;
        } while (stuttered);
        return Optional.empty();
    }

    private boolean declarationNameAlreadyExistsInOtherCFA(boolean isOtherOrigCFA, CDeclarationEdge pDeclEdge) {
        if (!pDeclEdge.getDeclaration().isGlobal() && this.containsDeclaration(isOtherOrigCFA ? this.funToVarsOrig.get(pDeclEdge.getSuccessor().getFunctionName()) : this.funToVarsGiven.get(pDeclEdge.getSuccessor().getFunctionName()), pDeclEdge.getDeclaration().getOrigName())) {
            return true;
        }
        return this.containsDeclaration(isOtherOrigCFA ? this.funToVarsOrig.get("") : this.funToVarsGiven.get(""), pDeclEdge.getDeclaration().getOrigName());
    }

    private boolean containsDeclaration(@Nullable Set<String> varNames, String varName) {
        return varNames != null && varNames.contains(varName);
    }

    private boolean edgesMatch(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal) {
        String sndAst;
        String firstAst = pEdgeInGiven.getRawStatement();
        return firstAst.equals(sndAst = pEdgeInOriginal.getRawStatement()) && pEdgeInGiven.getEdgeType() == pEdgeInOriginal.getEdgeType() && this.successorsMatch(pEdgeInGiven, pEdgeInOriginal);
    }

    private Optional<String> checkEdgeChangedAssignment(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal) {
        if (pEdgeInOriginal instanceof CStatementEdge) {
            String lhsInOriginal = CFAEdgeUtils.getLeftHandVariable(pEdgeInOriginal);
            String lhsInGiven = CFAEdgeUtils.getLeftHandVariable(pEdgeInGiven);
            if (lhsInOriginal != null && lhsInGiven != null && lhsInOriginal.equals(lhsInGiven)) {
                return Optional.of(lhsInOriginal);
            }
        }
        return Optional.empty();
    }

    private Optional<String> checkEdgeDeletedAssignment(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal) {
        String lhsInOriginal;
        if (pEdgeInOriginal instanceof CStatementEdge && (lhsInOriginal = CFAEdgeUtils.getLeftHandVariable(pEdgeInOriginal)) != null) {
            for (CFAEdge edgeLeavingOrigSuccessor : CFAUtils.leavingEdges(pEdgeInOriginal.getSuccessor())) {
                if (!this.edgesMatch(pEdgeInGiven, edgeLeavingOrigSuccessor)) continue;
                return Optional.of(lhsInOriginal);
            }
        }
        return Optional.empty();
    }

    private Optional<String> checkEdgeAddedAssignment(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal) {
        String lhsInGiven;
        if (pEdgeInGiven instanceof CStatementEdge && (lhsInGiven = CFAEdgeUtils.getLeftHandVariable(pEdgeInGiven)) != null) {
            for (CFAEdge edgeLeavingGivenSuccessor : CFAUtils.leavingEdges(pEdgeInGiven.getSuccessor())) {
                if (!this.edgesMatch(edgeLeavingGivenSuccessor, pEdgeInOriginal)) continue;
                return Optional.of(lhsInGiven);
            }
        }
        return Optional.empty();
    }

    private boolean successorsMatch(CFAEdge pEdgeInGiven, CFAEdge pEdgeInOriginal) {
        CFANode givenSuccessor = pEdgeInGiven.getSuccessor();
        CFANode originalSuccessor = pEdgeInOriginal.getSuccessor();
        if (pEdgeInGiven.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
            block0: for (CFAEdge enterBeforeCall : CFAUtils.enteringEdges(((FunctionReturnEdge)pEdgeInGiven).getSummaryEdge().getPredecessor())) {
                for (CFAEdge enterOriginalBeforeCAll : CFAUtils.enteringEdges(((FunctionReturnEdge)pEdgeInOriginal).getSummaryEdge().getPredecessor())) {
                    if (!this.edgesMatch(enterBeforeCall, enterOriginalBeforeCAll)) continue;
                    continue block0;
                }
                return false;
            }
        }
        return givenSuccessor.getClass() == originalSuccessor.getClass() && givenSuccessor.getFunctionName().equals(originalSuccessor.getFunctionName());
    }

    private ImmutableSet<String> removeVariableFromSetIfAssignedInEdge(CFAEdge pEdge, ImmutableSet<String> pVars) {
        String lhs;
        if (pEdge instanceof CStatementEdge && (lhs = CFAEdgeUtils.getLeftHandVariable(pEdge)) != null && pVars.contains((Object)lhs)) {
            return FluentIterable.from(pVars).filter(Predicates.not((Predicate)Predicates.equalTo((Object)lhs))).toSet();
        }
        return pVars;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean variablesAreUsedInEdge(CFAEdge pEdge, ImmutableSet<String> pVars) {
        Set<Object> usedVars;
        block19: {
            VariableIdentifierVisitor visitor;
            block22: {
                block21: {
                    block20: {
                        visitor = new VariableIdentifierVisitor();
                        usedVars = new HashSet();
                        if (!(pEdge instanceof CDeclarationEdge)) break block20;
                        CDeclaration decl = ((CDeclarationEdge)pEdge).getDeclaration();
                        if (decl instanceof CFunctionDeclaration) return false;
                        if (decl instanceof CTypeDeclaration) {
                            return false;
                        }
                        if (decl instanceof CVariableDeclaration) {
                            CInitializer initl = ((CVariableDeclaration)decl).getInitializer();
                            if (initl instanceof CInitializerExpression) {
                                usedVars = ((CInitializerExpression)initl).getExpression().accept(visitor);
                                break block19;
                            } else {
                                if (pVars.isEmpty()) return false;
                                return true;
                            }
                        }
                        break block19;
                    }
                    if (pEdge instanceof CReturnStatementEdge) {
                        CExpression exp = ((CReturnStatementEdge)pEdge).getExpression().orElse(null);
                        if (exp != null) {
                            usedVars = exp.accept(visitor);
                            break block19;
                        } else {
                            if (pVars.isEmpty()) return false;
                            return true;
                        }
                    }
                    if (!(pEdge instanceof CAssumeEdge)) break block21;
                    usedVars = ((CAssumeEdge)pEdge).getExpression().accept(visitor);
                    break block19;
                }
                if (!(pEdge instanceof CStatementEdge)) break block22;
                CStatement stmt = ((CStatementEdge)pEdge).getStatement();
                if (stmt instanceof CExpressionStatement) {
                    usedVars = ((CExpressionStatement)stmt).getExpression().accept(visitor);
                    break block19;
                } else {
                    if (stmt instanceof CAssignment) {
                        CLeftHandSide lhs = ((CAssignment)stmt).getLeftHandSide();
                        if (!(lhs instanceof CIdExpression)) {
                            usedVars.addAll((Collection)lhs.accept(visitor));
                        }
                        if (stmt instanceof CExpressionAssignmentStatement) {
                            usedVars.addAll((Collection<Object>)((CExpressionAssignmentStatement)stmt).getRightHandSide().accept(visitor));
                        }
                    }
                    if (stmt instanceof CFunctionCall) {
                        CFunctionCallExpression funCall = ((CFunctionCall)stmt).getFunctionCallExpression();
                        usedVars.addAll((Collection<Object>)funCall.getFunctionNameExpression().accept(visitor));
                        for (CExpression exp : funCall.getParameterExpressions()) {
                            usedVars.addAll((Collection<Object>)exp.accept(visitor));
                        }
                    }
                }
                break block19;
            }
            if (pEdge instanceof BlankEdge) {
                return false;
            }
            if (pEdge instanceof CFunctionCallEdge) {
                for (CExpression exp : ((CFunctionCallEdge)pEdge).getArguments()) {
                    usedVars.addAll((Collection<Object>)exp.accept(visitor));
                }
            } else {
                if (pEdge instanceof CFunctionSummaryEdge) return false;
                if (pEdge instanceof CFunctionReturnEdge) {
                    return false;
                }
                if (pVars.isEmpty()) return false;
                return true;
            }
        }
        if (Collections.disjoint(usedVars, pVars)) return false;
        return true;
    }
}

