/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorMerge;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorState;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorStatistics;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorStop;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorTransferRelation;

public class MonitorCPA
extends AbstractSingleWrapperCPA {
    private final MonitorTransferRelation transferRelation;
    private final Statistics stats;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(MonitorCPA.class);
    }

    private MonitorCPA(ConfigurableProgramAnalysis pCpa, Configuration config) throws InvalidConfigurationException {
        super(pCpa);
        this.transferRelation = new MonitorTransferRelation(this.getWrappedCpa(), config);
        this.stats = new MonitorStatistics(this);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return new FlatLatticeDomain();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return new MonitorState(this.getWrappedCpa().getInitialState(pNode, pPartition), 0L);
    }

    @Override
    public MergeOperator getMergeOperator() {
        return new MonitorMerge(this.getWrappedCpa());
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return new MonitorPrecisionAdjustment(this.getWrappedCpa().getPrecisionAdjustment());
    }

    @Override
    public StopOperator getStopOperator() {
        return new MonitorStop(this.getWrappedCpa());
    }

    @Override
    public MonitorTransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        super.collectStatistics(pStatsCollection);
    }
}

