/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class MonitorMerge
implements MergeOperator {
    private ConfigurableProgramAnalysis wrappedCpa;

    public MonitorMerge(ConfigurableProgramAnalysis pWrappedCPA) {
        this.wrappedCpa = pWrappedCPA;
    }

    @Override
    public AbstractState merge(AbstractState pElement1, AbstractState pElement2, Precision pPrecision) throws CPAException, InterruptedException {
        AbstractState wrappedState2;
        AbstractState wrappedState1;
        MonitorState monitorState1 = (MonitorState)pElement1;
        MonitorState monitorState2 = (MonitorState)pElement2;
        if (monitorState1.mustDumpAssumptionForAvoidance() || monitorState2.mustDumpAssumptionForAvoidance()) {
            return pElement2;
        }
        MergeOperator mergeOperator = this.wrappedCpa.getMergeOperator();
        AbstractState retElement = mergeOperator.merge(wrappedState1 = monitorState1.getWrappedState(), wrappedState2 = monitorState2.getWrappedState(), pPrecision);
        if (retElement.equals(wrappedState2)) {
            return pElement2;
        }
        long totalTimeOnPath = Math.max(monitorState1.getTotalTimeOnPath(), monitorState2.getTotalTimeOnPath());
        MonitorState mergedElement = new MonitorState(retElement, totalTimeOnPath);
        return mergedElement;
    }
}

