/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetView;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;

public class MonitorPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment wrappedPrecAdjustment;
    final Timer totalTimeOfPrecAdj = new Timer();

    public MonitorPrecisionAdjustment(PrecisionAdjustment pWrappedPrecAdjustment) {
        this.wrappedPrecAdjustment = pWrappedPrecAdjustment;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pElement, Precision oldPrecision, UnmodifiableReachedSet pElements, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pElement instanceof MonitorState));
        MonitorState element = (MonitorState)pElement;
        if (element.getWrappedState() == MonitorState.TimeoutState.INSTANCE) {
            return Optional.of(PrecisionAdjustmentResult.create(pElement, oldPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
        }
        UnmodifiableReachedSetView elements = new UnmodifiableReachedSetView(pElements, (Function<? super AbstractState, AbstractState>)((Function)state -> ((MonitorState)state).getWrappedState()), (Function<? super Precision, Precision>)Functions.identity());
        AbstractState oldElement = element.getWrappedState();
        this.totalTimeOfPrecAdj.start();
        Optional<PrecisionAdjustmentResult> unwrappedResult = this.wrappedPrecAdjustment.prec(oldElement, oldPrecision, elements, (Function<AbstractState, AbstractState>)Functions.compose(state -> ((MonitorState)state).getWrappedState(), projection), fullState);
        this.totalTimeOfPrecAdj.stop();
        long totalTimeOfExecution = this.totalTimeOfPrecAdj.getLengthOfLastInterval().asMillis();
        long updatedTotalTime = totalTimeOfExecution + element.getTotalTimeOnPath();
        Pair<PreventingHeuristic, Long> preventingCondition = element.getPreventingCondition();
        if (!unwrappedResult.isPresent()) {
            return Optional.empty();
        }
        PrecisionAdjustmentResult unwrapped = unwrappedResult.orElseThrow();
        MonitorState resultElement = new MonitorState(unwrapped.abstractState(), updatedTotalTime, preventingCondition);
        return Optional.of(unwrapped.withAbstractState(resultElement));
    }
}

