/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class MonitorState
extends AbstractSingleWrapperState
implements AvoidanceReportingState {
    private final long totalTimeOnPath;
    private final @Nullable Pair<PreventingHeuristic, Long> preventingCondition;

    protected MonitorState(AbstractState pWrappedState, long totalTimeOnPath) {
        this(pWrappedState, totalTimeOnPath, null);
    }

    protected MonitorState(AbstractState pWrappedState, long totalTimeOnPath, Pair<PreventingHeuristic, Long> preventingCondition) {
        super(pWrappedState);
        Preconditions.checkArgument((!(pWrappedState instanceof MonitorState) ? 1 : 0) != 0, (Object)"Don't wrap a MonitorCPA in a MonitorCPA, this makes no sense!");
        Preconditions.checkArgument((pWrappedState != TimeoutState.INSTANCE || preventingCondition != null ? 1 : 0) != 0, (Object)"Need a preventingCondition in case of TimeoutState");
        this.totalTimeOnPath = totalTimeOnPath;
        this.preventingCondition = preventingCondition;
    }

    public long getTotalTimeOnPath() {
        return this.totalTimeOnPath;
    }

    @Override
    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof MonitorState) {
            MonitorState otherElem = (MonitorState)pObj;
            return this.getWrappedState().equals(otherElem.getWrappedState());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getWrappedState().hashCode();
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.preventingCondition != null;
    }

    Pair<PreventingHeuristic, Long> getPreventingCondition() {
        return this.preventingCondition;
    }

    @Override
    public String toString() {
        return String.format("Total time: %s Wrapped elem: %s", this.totalTimeOnPath, this.getWrappedStates());
    }

    @Override
    public BooleanFormula getReasonFormula(FormulaManagerView manager) {
        if (this.mustDumpAssumptionForAvoidance()) {
            return this.preventingCondition.getFirst().getFormula(manager, this.preventingCondition.getSecond());
        }
        BooleanFormulaManagerView bfmgr = manager.getBooleanFormulaManager();
        return bfmgr.makeTrue();
    }

    static enum TimeoutState implements AbstractState
    {
        INSTANCE;


        @Override
        public String toString() {
            return "Dummy element because computation timed out";
        }
    }
}

