/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorCPA;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorTransferRelation;

class MonitorStatistics
implements Statistics {
    private final MonitorCPA mCpa;

    MonitorStatistics(MonitorCPA pCpa) {
        this.mCpa = pCpa;
    }

    @Override
    public String getName() {
        return "MonitorCPA";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        MonitorTransferRelation trans = this.mCpa.getTransferRelation();
        out.println("Max. Post Time:            " + trans.totalTimeOfTransfer.getMaxTime().formatAs(TimeUnit.SECONDS));
        out.println("Avg. Post Time:            " + trans.totalTimeOfTransfer.getAvgTime().formatAs(TimeUnit.SECONDS));
        out.println("Max Post time on a path:   " + TimeSpan.ofMillis((long)trans.maxTotalTimeForPath).formatAs(TimeUnit.SECONDS));
    }
}

