/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.monitor;

import java.util.Collection;
import java.util.Collections;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class MonitorStop
implements StopOperator {
    private final ConfigurableProgramAnalysis wrappedCpa;

    public MonitorStop(ConfigurableProgramAnalysis cpa) {
        this.wrappedCpa = cpa;
    }

    @Override
    public boolean stop(AbstractState pElement, Collection<AbstractState> pReached, Precision pPrecision) throws CPAException, InterruptedException {
        MonitorState monitorState = (MonitorState)pElement;
        if (monitorState.mustDumpAssumptionForAvoidance()) {
            return false;
        }
        AbstractState wrappedState = monitorState.getWrappedState();
        StopOperator stopOp = this.wrappedCpa.getStopOperator();
        for (AbstractState reachedState : pReached) {
            MonitorState monitorReachedState = (MonitorState)reachedState;
            if (monitorReachedState.mustDumpAssumptionForAvoidance()) {
                return false;
            }
            AbstractState wrappedReachedState = monitorReachedState.getWrappedState();
            if (!stopOp.stop(wrappedState, Collections.singleton(wrappedReachedState), pPrecision)) continue;
            return true;
        }
        return false;
    }
}

